/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.source;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.source.SourceDependency;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NonNullByDefault
public interface SourceInfo {
    public SourceIdentifier sourceId();

    public YangVersion yangVersion();

    public ImmutableSet<Revision> revisions();

    public ImmutableSet<SourceDependency.Import> imports();

    public ImmutableSet<SourceDependency.Include> includes();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Builder<B extends Builder<B, I>, I extends SourceInfo> {
        private final ImmutableSet.Builder<SourceDependency.Import> imports = ImmutableSet.builder();
        private final ImmutableSet.Builder<SourceDependency.Include> includes = ImmutableSet.builder();
        private final ArrayList<Revision> revisions = new ArrayList();
        private YangVersion yangVersion = YangVersion.VERSION_1;
        @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="https://github.com/spotbugs/spotbugs/issues/743")
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable UnresolvedQName.Unqualified name;

        public final B setName(UnresolvedQName.Unqualified newName) {
            this.name = Objects.requireNonNull(newName);
            return this.thisInstance();
        }

        public final B setYangVersion(YangVersion newYangVersion) {
            this.yangVersion = Objects.requireNonNull(newYangVersion);
            return this.thisInstance();
        }

        public final B addImport(SourceDependency.Import importDep) {
            this.imports.add((Object)importDep);
            return this.thisInstance();
        }

        public final B addInclude(SourceDependency.Include includeDep) {
            this.includes.add((Object)includeDep);
            return this.thisInstance();
        }

        public final B addRevision(Revision revision) {
            this.revisions.add(revision);
            return this.thisInstance();
        }

        public final I build() {
            ImmutableSet sorted;
            return this.buildInstance(new SourceIdentifier(Objects.requireNonNull(this.name), (sorted = (ImmutableSet)this.revisions.stream().sorted(Comparator.reverseOrder()).collect(ImmutableSet.toImmutableSet())).isEmpty() ? null : (Revision)sorted.iterator().next()), this.yangVersion, (ImmutableSet<Revision>)sorted, (ImmutableSet<SourceDependency.Import>)this.imports.build(), (ImmutableSet<SourceDependency.Include>)this.includes.build());
        }

        abstract I buildInstance(SourceIdentifier var1, YangVersion var2, ImmutableSet<Revision> var3, ImmutableSet<SourceDependency.Import> var4, ImmutableSet<SourceDependency.Include> var5);

        private B thisInstance() {
            return (B)this;
        }
    }

    public record Submodule(SourceIdentifier sourceId, YangVersion yangVersion, SourceDependency.BelongsTo belongsTo, ImmutableSet<Revision> revisions, ImmutableSet<SourceDependency.Import> imports, ImmutableSet<SourceDependency.Include> includes) implements SourceInfo
    {
        public Submodule {
            Objects.requireNonNull(sourceId);
            Objects.requireNonNull(yangVersion);
            Objects.requireNonNull(belongsTo);
            Objects.requireNonNull(revisions);
            Objects.requireNonNull(imports);
            Objects.requireNonNull(imports);
            Objects.requireNonNull(includes);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        extends org.opendaylight.yangtools.yang.model.spi.source.SourceInfo$Builder<Builder, Submodule> {
            @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="https://github.com/spotbugs/spotbugs/issues/743")
            private // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable SourceDependency.BelongsTo belongsTo;

            Builder() {
            }

            public Builder setBelongsTo(SourceDependency.BelongsTo belongsTo) {
                this.belongsTo = Objects.requireNonNull(belongsTo);
                return this;
            }

            @Override
            Submodule buildInstance(SourceIdentifier sourceId, YangVersion yangVersion, ImmutableSet<Revision> revisions, ImmutableSet<SourceDependency.Import> imports, ImmutableSet<SourceDependency.Include> includes) {
                return new Submodule(sourceId, yangVersion, Objects.requireNonNull(this.belongsTo), revisions, imports, includes);
            }
        }
    }

    public record Module(SourceIdentifier sourceId, YangVersion yangVersion, XMLNamespace namespace, UnresolvedQName.Unqualified prefix, ImmutableSet<Revision> revisions, ImmutableSet<SourceDependency.Import> imports, ImmutableSet<SourceDependency.Include> includes) implements SourceInfo
    {
        public Module {
            Objects.requireNonNull(sourceId);
            Objects.requireNonNull(yangVersion);
            Objects.requireNonNull(namespace);
            Objects.requireNonNull(prefix);
            Objects.requireNonNull(revisions);
            Objects.requireNonNull(imports);
            Objects.requireNonNull(includes);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        extends org.opendaylight.yangtools.yang.model.spi.source.SourceInfo$Builder<Builder, Module> {
            @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="https://github.com/spotbugs/spotbugs/issues/743")
            private @Nullable XMLNamespace namespace;
            @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="https://github.com/spotbugs/spotbugs/issues/743")
            private // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable UnresolvedQName.Unqualified prefix;

            Builder() {
            }

            public Builder setNamespace(XMLNamespace namespace) {
                this.namespace = Objects.requireNonNull(namespace);
                return this;
            }

            public Builder setPrefix(UnresolvedQName.Unqualified prefix) {
                this.prefix = Objects.requireNonNull(prefix);
                return this;
            }

            @Override
            Module buildInstance(SourceIdentifier sourceId, YangVersion yangVersion, ImmutableSet<Revision> revisions, ImmutableSet<SourceDependency.Import> imports, ImmutableSet<SourceDependency.Include> includes) {
                return new Module(sourceId, yangVersion, Objects.requireNonNull(this.namespace), Objects.requireNonNull(this.prefix), revisions, imports, includes);
            }
        }
    }
}

