/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMountpoints;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.InputStreamNormalizer;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizationException;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizationResult;
import org.opendaylight.yangtools.yang.data.util.codec.AbstractCodecFactory;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.TypeAwareCodec;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public abstract class AbstractInputStreamNormalizer<T extends TypeAwareCodec<?, ?, ?>>
extends AbstractCodecFactory<T>
implements InputStreamNormalizer {
    protected AbstractInputStreamNormalizer(@NonNull EffectiveModelContext schemaContext, @NonNull CodecCache<T> cache) {
        super(schemaContext, cache);
    }

    public final NormalizationResult<ContainerNode> parseDatastore(YangInstanceIdentifier.NodeIdentifier containerName, UnresolvedQName.Unqualified moduleName, InputStream stream) throws NormalizationException {
        try {
            return this.parseDatastore(Objects.requireNonNull(stream), Objects.requireNonNull(containerName), Objects.requireNonNull(moduleName));
        }
        catch (IOException | IllegalArgumentException e) {
            throw NormalizationException.ofCause((Throwable)e);
        }
    }

    protected abstract @NonNull NormalizationResult<ContainerNode> parseDatastore(@NonNull InputStream var1, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier var2, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull UnresolvedQName.Unqualified var3) throws IOException, NormalizationException;

    public final NormalizationResult<?> parseData(EffectiveStatementInference inference, InputStream stream) throws NormalizationException {
        NormalizationResult<?> data;
        SchemaInferenceStack stack = this.checkInferenceNotEmpty(inference);
        EffectiveStatement stmt = stack.currentStatement();
        if (!(stmt instanceof DataTreeEffectiveStatement)) {
            throw new IllegalArgumentException("Invalid inference statement " + stmt);
        }
        DataTreeEffectiveStatement dataStmt = (DataTreeEffectiveStatement)stmt;
        try {
            data = this.parseData(stack, Objects.requireNonNull(stream));
        }
        catch (IOException | IllegalArgumentException e) {
            throw NormalizationException.ofCause((Throwable)e);
        }
        return AbstractInputStreamNormalizer.checkNodeName(data, (QName)dataStmt.argument());
    }

    protected abstract @NonNull NormalizationResult<?> parseData(@NonNull SchemaInferenceStack var1, @NonNull InputStream var2) throws IOException, NormalizationException;

    public final InputStreamNormalizer.PrefixAndResult parseChildData(EffectiveStatementInference inference, InputStream stream) throws NormalizationException {
        NormalizationResult<?> normalized;
        this.checkInference(inference);
        try {
            normalized = this.parseChildData(Objects.requireNonNull(stream), inference);
        }
        catch (IOException | IllegalArgumentException e) {
            throw NormalizationException.ofCause((Throwable)e);
        }
        ArrayList<Object> prefix = new ArrayList<Object>();
        NormalizedNode data = normalized.data();
        NormalizedMetadata metadata = normalized.metadata();
        NormalizedMountpoints mountPoints = normalized.mountPoints();
        while (data instanceof ChoiceNode) {
            ChoiceNode choice = (ChoiceNode)data;
            prefix.add(choice.name());
            data = (NormalizedNode)choice.body().iterator().next();
        }
        if (data instanceof MapNode || data instanceof LeafSetNode || data instanceof UnkeyedListNode) {
            YangInstanceIdentifier.PathArgument dataName = data.name();
            Collection body = ((NormalizedNodeContainer)data).body();
            int size = body.size();
            if (body.size() != 1) {
                throw NormalizationException.ofMessage((String)("Exactly one instance of " + dataName.getNodeType() + " is required, " + size + " supplied"));
            }
            prefix.add(dataName);
            data = (NormalizedNode)body.iterator().next();
            if (metadata != null) {
                metadata = (NormalizedMetadata)metadata.getChildren().get(dataName);
            }
            if (mountPoints != null) {
                mountPoints = (NormalizedMountpoints)mountPoints.getChildren().get(dataName);
            }
        }
        return new InputStreamNormalizer.PrefixAndResult(prefix, new NormalizationResult(data, metadata, mountPoints));
    }

    protected abstract @NonNull NormalizationResult<?> parseChildData(@NonNull InputStream var1, @NonNull EffectiveStatementInference var2) throws IOException, NormalizationException;

    public final NormalizationResult<ContainerNode> parseInput(EffectiveStatementInference inference, InputStream stream) throws NormalizationException {
        QName expected;
        SchemaInferenceStack stack = this.checkInferenceNotEmpty(inference);
        EffectiveStatement stmt = stack.currentStatement();
        if (stmt instanceof RpcEffectiveStatement) {
            RpcEffectiveStatement rpc = (RpcEffectiveStatement)stmt;
            expected = (QName)rpc.input().argument();
        } else if (stmt instanceof ActionEffectiveStatement) {
            ActionEffectiveStatement action = (ActionEffectiveStatement)stmt;
            expected = (QName)action.input().argument();
        } else {
            throw new IllegalArgumentException("Invalid inference statement " + stmt);
        }
        return this.parseInputOutput(stream, stack, expected);
    }

    public final NormalizationResult<ContainerNode> parseOutput(EffectiveStatementInference inference, InputStream stream) throws NormalizationException {
        QName expected;
        SchemaInferenceStack stack = this.checkInferenceNotEmpty(inference);
        EffectiveStatement stmt = stack.currentStatement();
        if (stmt instanceof RpcEffectiveStatement) {
            RpcEffectiveStatement rpc = (RpcEffectiveStatement)stmt;
            expected = (QName)rpc.output().argument();
        } else if (stmt instanceof ActionEffectiveStatement) {
            ActionEffectiveStatement action = (ActionEffectiveStatement)stmt;
            expected = (QName)action.output().argument();
        } else {
            throw new IllegalArgumentException("Invalid inference statement " + stmt);
        }
        return this.parseInputOutput(stream, stack, expected);
    }

    private @NonNull NormalizationResult<ContainerNode> parseInputOutput(@NonNull InputStream stream, @NonNull SchemaInferenceStack stack, @NonNull QName expected) throws NormalizationException {
        NormalizationResult<?> data;
        try {
            data = this.parseInputOutput(stack, expected, Objects.requireNonNull(stream));
        }
        catch (IOException | IllegalArgumentException e) {
            throw NormalizationException.ofCause((Throwable)e);
        }
        return AbstractInputStreamNormalizer.checkNodeContainer(data);
    }

    protected abstract @NonNull NormalizationResult<?> parseInputOutput(@NonNull SchemaInferenceStack var1, @NonNull QName var2, @NonNull InputStream var3) throws IOException, NormalizationException;

    private void checkInference(EffectiveStatementInference inference) {
        EffectiveModelContext local = this.modelContext();
        if (!local.equals(inference.modelContext())) {
            throw new IllegalArgumentException("Mismatched inference, expecting model context " + local);
        }
    }

    private @NonNull SchemaInferenceStack checkInferenceNotEmpty(EffectiveStatementInference inference) {
        this.checkInference(inference);
        SchemaInferenceStack stack = SchemaInferenceStack.ofInference((EffectiveStatementInference)inference);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Inference must not be empty");
        }
        return stack;
    }

    protected static final @NonNull NormalizationResult<ContainerNode> checkNodeContainer(NormalizationResult<?> result) throws NormalizationException {
        NormalizedNode data = result.data();
        if (data instanceof ContainerNode) {
            return result;
        }
        throw NormalizationException.ofMessage((String)("Unexpected payload type " + data.contract()));
    }

    protected static final @NonNull NormalizationResult<?> checkNodeName(NormalizationResult<?> result, QName expected) throws NormalizationException {
        QName qname = result.data().name().getNodeType();
        if (qname.equals((Object)expected)) {
            return result;
        }
        throw NormalizationException.ofMessage((String)("Payload name " + qname + " is different from identifier name " + expected));
    }
}

