/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class LeafInterner {
    private static final Logger LOG = LoggerFactory.getLogger(LeafInterner.class);
    private static final Interner<Object> INTERNER = Interners.newWeakInterner();

    private LeafInterner() {
    }

    private static <T extends LeafNode<?>> T intern(T sample) {
        LeafNode ret = (LeafNode)INTERNER.intern(sample);
        LOG.trace("Interned object {} to {}", sample, (Object)ret);
        return (T)ret;
    }

    public static <T extends LeafNode<?>> @NonNull Optional<Interner<T>> forSchema(@Nullable LeafSchemaNode schema) {
        if (schema != null && LeafInterner.isLowCardinality(schema.getType())) {
            return Optional.of(LeafInterner::intern);
        }
        return Optional.empty();
    }

    private static boolean isLowCardinality(TypeDefinition<?> type) {
        return type instanceof BooleanTypeDefinition || type instanceof EmptyTypeDefinition || type instanceof EnumTypeDefinition || type instanceof IdentityrefTypeDefinition || type instanceof Int8TypeDefinition || type instanceof Uint8TypeDefinition;
    }
}

