/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangNumberExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathMathSupport;

public abstract class AbstractYangXPathMathSupport<N extends YangNumberExpr>
implements YangXPathMathSupport {
    private static final long serialVersionUID = 1L;
    private final Class<N> numberClass;

    protected AbstractYangXPathMathSupport(Class<N> numberClass) {
        this.numberClass = Objects.requireNonNull(numberClass);
    }

    public final N negateNumber(YangNumberExpr number) {
        Preconditions.checkArgument((boolean)this.numberClass.isInstance(Objects.requireNonNull(number)), (String)"Expected %s have %s", this.numberClass, (Object)number);
        return (N)this.doNegateNumber((YangNumberExpr)this.numberClass.cast(number));
    }

    @Override
    public final Optional<YangExpr> tryEvaluate(YangBinaryOperator operator, YangNumberExpr left, YangNumberExpr right) {
        if (!this.numberClass.isInstance(left) || !this.numberClass.isInstance(right)) {
            Objects.requireNonNull(operator);
            Objects.requireNonNull(left);
            Objects.requireNonNull(right);
            return Optional.empty();
        }
        return Optional.of(this.doEvaluate(Objects.requireNonNull(operator), (YangNumberExpr)this.numberClass.cast(left), (YangNumberExpr)this.numberClass.cast(right)));
    }

    protected abstract N doNegateNumber(N var1);

    protected abstract YangExpr doEvaluate(YangBinaryOperator var1, N var2, N var3);

    protected abstract Object readResolve();
}

