/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.MountPointLabel;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ForwardingNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizationResult;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedMountPoint;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedMountpoints;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;

@Beta
public abstract class ImmutableMountPointNormalizedNodeStreamWriter
extends ImmutableNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter.MountPointExtension {
    private final Deque<BuilderEntry> builders = new ArrayDeque<BuilderEntry>();
    private final NormalizationResultHolder holder;

    protected ImmutableMountPointNormalizedNodeStreamWriter(NormalizationResultHolder holder) {
        super(holder);
        this.holder = Objects.requireNonNull(holder);
    }

    public final List<NormalizedNodeStreamWriter.MountPointExtension> supportedExtensions() {
        return List.of(this);
    }

    public final NormalizedNodeStreamWriter startMountPoint(final MountPointLabel label, final MountPointContext mountCtx) {
        final BuilderEntry current = this.builders.peek();
        Preconditions.checkState((current != null ? 1 : 0) != 0, (Object)"Attempted to emit mount point when no data is open");
        final NormalizationResultHolder mountResult = new NormalizationResultHolder();
        final NormalizedNodeStreamWriter mountDelegate = ImmutableNormalizedNodeStreamWriter.from(mountResult);
        return new ForwardingNormalizedNodeStreamWriter(){

            protected NormalizedNodeStreamWriter delegate() {
                return mountDelegate;
            }

            public void close() throws IOException {
                super.close();
                NormalizationResult<?> result = mountResult.getResult();
                NormalizedNode data = result.data();
                if (!(data instanceof ContainerNode)) {
                    throw new IOException("Unhandled mount data " + data);
                }
                ContainerNode container = (ContainerNode)data;
                current.builder.withMountPoint(new ImmutableNormalizedMountPoint(label, mountCtx, container, result.metadata(), result.mountPoints()));
            }
        };
    }

    @Override
    final void enter(YangInstanceIdentifier.PathArgument identifier, NormalizedNodeBuilder next) {
        super.enter(identifier, next);
        this.builders.push(new BuilderEntry(identifier, ImmutableNormalizedMountpoints.builder()));
    }

    @Override
    public final void endNode() {
        super.endNode();
        BuilderEntry last = this.builders.pop();
        ImmutableNormalizedMountpoints mountPoints = last.builder.build();
        BuilderEntry current = this.builders.peek();
        if (current != null) {
            if (mountPoints.mountPoint() != null || !mountPoints.getChildren().isEmpty()) {
                current.builder.withChild(last.identifier, mountPoints);
            }
        } else {
            this.holder.setMountPoints(mountPoints);
        }
    }

    @NonNullByDefault
    private record BuilderEntry(YangInstanceIdentifier.PathArgument identifier, ImmutableNormalizedMountpoints.Builder builder) {
        BuilderEntry {
            Objects.requireNonNull(identifier);
            Objects.requireNonNull(builder);
        }
    }
}

