/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.AbstractListeningExecutorService;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.concurrent.AsyncNotifyingListenableFutureTask;

public class AsyncNotifyingListeningExecutorService
extends AbstractListeningExecutorService {
    private final @NonNull ExecutorService delegate;
    private final @Nullable Executor listenableFutureExecutor;

    public AsyncNotifyingListeningExecutorService(@NonNull ExecutorService delegate, @Nullable Executor listenableFutureExecutor) {
        this.delegate = Objects.requireNonNull(delegate);
        this.listenableFutureExecutor = listenableFutureExecutor;
    }

    private <T> @NonNull AsyncNotifyingListenableFutureTask<T> newFutureTask(@NonNull Runnable task, T result) {
        return AsyncNotifyingListenableFutureTask.create(task, result, this.listenableFutureExecutor);
    }

    protected @NonNull ExecutorService getDelegate() {
        return this.delegate;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        AsyncNotifyingListenableFutureTask<T> futureTask = AsyncNotifyingListenableFutureTask.create(Objects.requireNonNull(task), this.listenableFutureExecutor);
        this.delegate.execute(futureTask);
        return futureTask;
    }

    public ListenableFuture<?> submit(Runnable task) {
        AsyncNotifyingListenableFutureTask<Object> futureTask = this.newFutureTask(Objects.requireNonNull(task), null);
        this.delegate.execute(futureTask);
        return futureTask;
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        AsyncNotifyingListenableFutureTask<T> futureTask = this.newFutureTask(Objects.requireNonNull(task), result);
        this.delegate.execute(futureTask);
        return futureTask;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper addToStringAttributes(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)((Object)this)).add("delegate", (Object)this.delegate)).toString();
    }
}

