/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import org.eclipse.jdt.annotation.NonNull;
import tech.pantheon.triemap.LNodeEntry;
import tech.pantheon.triemap.SNode;

final class Result<T> {
    private static final @NonNull Result<?> EMPTY = new Result<Object>(null);
    private final T value;

    private Result(T value) {
        this.value = value;
    }

    static <T> @NonNull Result<T> empty() {
        return EMPTY;
    }

    static <T> @NonNull Result<T> of(LNodeEntry<?, T> entry) {
        return new Result<T>(entry.getValue());
    }

    static <T> @NonNull Result<T> of(SNode<?, T> snode) {
        return new Result(snode.value);
    }

    boolean isPresent() {
        return this.value != null;
    }

    T orNull() {
        return this.value;
    }
}

