/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import tech.pantheon.triemap.BasicNode;
import tech.pantheon.triemap.ImmutableTrieMap;

abstract class MainNode<K, V>
extends BasicNode {
    static final int NO_SIZE = -1;
    private static final VarHandle PREV;
    private volatile MainNode<K, V> prev;

    MainNode() {
        this.prev = null;
    }

    MainNode(MainNode<K, V> prev) {
        this.prev = prev;
    }

    abstract int trySize();

    abstract int size(ImmutableTrieMap<?, ?> var1);

    final boolean casPrev(MainNode<K, V> oldval, MainNode<K, V> nval) {
        return PREV.compareAndSet(this, oldval, nval);
    }

    final void writePrev(MainNode<K, V> nval) {
        this.prev = nval;
    }

    final MainNode<K, V> readPrev() {
        return this.prev;
    }

    static {
        try {
            PREV = MethodHandles.lookup().findVarHandle(MainNode.class, "prev", MainNode.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

