/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.checkerframework.checker.regex.qual.Regex;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.RUv1;
import org.opendaylight.yangtools.yang.common.RevisionUnion;

public final class Revision
implements RevisionUnion {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final @Regex String STRING_FORMAT_PATTERN_STR = "\\d\\d\\d\\d\\-\\d\\d-\\d\\d";
    public static final Pattern STRING_FORMAT_PATTERN = Pattern.compile("\\d\\d\\d\\d\\-\\d\\d-\\d\\d");
    public static final Revision MAX_VALUE = Revision.of("9999-12-31");
    private final @NonNull String str;

    private Revision(@NonNull String str) {
        FORMATTER.parse(str);
        this.str = str;
    }

    public static @NonNull Revision of(@NonNull String str) {
        return new Revision(str);
    }

    public static @NonNull Optional<Revision> ofNullable(@Nullable String str) {
        return str == null ? Optional.empty() : Optional.of(new Revision(str));
    }

    @Override
    public Revision revision() {
        return this;
    }

    @Override
    public String unionString() {
        return this.str;
    }

    public static int compare(@NonNull Optional<Revision> first, @NonNull Optional<Revision> second) {
        if (first.isPresent()) {
            return second.isPresent() ? first.orElseThrow().compareTo(second.orElseThrow()) : 1;
        }
        return second.isPresent() ? -1 : 0;
    }

    public static int compare(@Nullable Revision first, @Nullable Revision second) {
        if (first != null) {
            return second != null ? first.compareTo(second) : 1;
        }
        return second != null ? -1 : 0;
    }

    @Override
    public int hashCode() {
        return this.str.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Revision)) return false;
        Revision other = (Revision)obj;
        if (!this.str.equals(other.str)) return false;
        return true;
    }

    @Override
    public String toString() {
        return this.str;
    }

    Object writeReplace() {
        return new RUv1(this.str);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Revision.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        Revision.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        Revision.throwNSE();
    }

    static void throwNSE() throws NotSerializableException {
        throw new NotSerializableException(Revision.class.getName());
    }

    @Deprecated(since="12.0.0", forRemoval=true)
    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private Revision revision;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            throw new NotSerializableException(Proxy.class.getName());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.revision = Revision.of((String)in.readObject());
        }

        private Object readResolve() {
            return Objects.requireNonNull(this.revision);
        }
    }
}

