/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module.ModuleEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module.QNameModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractUnqualifiedStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class ModuleStatementSupport
extends AbstractUnqualifiedStatementSupport<ModuleStatement, ModuleEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.MODULE).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.AUGMENT).addAny((StatementDefinition)YangStmtMapping.CHOICE).addOptional((StatementDefinition)YangStmtMapping.CONTACT).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.DEVIATION).addAny((StatementDefinition)YangStmtMapping.EXTENSION).addAny((StatementDefinition)YangStmtMapping.FEATURE).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IDENTITY).addAny((StatementDefinition)YangStmtMapping.IMPORT).addAny((StatementDefinition)YangStmtMapping.INCLUDE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addMandatory((StatementDefinition)YangStmtMapping.NAMESPACE).addAny((StatementDefinition)YangStmtMapping.NOTIFICATION).addOptional((StatementDefinition)YangStmtMapping.ORGANIZATION).addMandatory((StatementDefinition)YangStmtMapping.PREFIX).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addAny((StatementDefinition)YangStmtMapping.REVISION).addAny((StatementDefinition)YangStmtMapping.RPC).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.USES).addOptional((StatementDefinition)YangStmtMapping.YANG_VERSION).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.MODULE).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.AUGMENT).addAny((StatementDefinition)YangStmtMapping.CHOICE).addOptional((StatementDefinition)YangStmtMapping.CONTACT).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.DEVIATION).addAny((StatementDefinition)YangStmtMapping.EXTENSION).addAny((StatementDefinition)YangStmtMapping.FEATURE).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IDENTITY).addAny((StatementDefinition)YangStmtMapping.IMPORT).addAny((StatementDefinition)YangStmtMapping.INCLUDE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addMandatory((StatementDefinition)YangStmtMapping.NAMESPACE).addAny((StatementDefinition)YangStmtMapping.NOTIFICATION).addOptional((StatementDefinition)YangStmtMapping.ORGANIZATION).addMandatory((StatementDefinition)YangStmtMapping.PREFIX).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addAny((StatementDefinition)YangStmtMapping.REVISION).addAny((StatementDefinition)YangStmtMapping.RPC).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.USES).addMandatory((StatementDefinition)YangStmtMapping.YANG_VERSION).build();

    private ModuleStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.MODULE, StatementSupport.StatementPolicy.reject(), config, validator);
    }

    public static @NonNull ModuleStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new ModuleStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull ModuleStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new ModuleStatementSupport(config, RFC7950_VALIDATOR);
    }

    public void onPreLinkageDeclared(StmtContext.Mutable<UnresolvedQName.Unqualified, ModuleStatement, ModuleEffectiveStatement> stmt) {
        UnresolvedQName.Unqualified moduleName = (UnresolvedQName.Unqualified)stmt.getArgument();
        XMLNamespace moduleNs = (XMLNamespace)SourceException.throwIfNull((Object)((XMLNamespace)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), NamespaceStatement.class)), stmt, (String)"Namespace of the module [%s] is missing", (Object[])new Object[]{moduleName});
        stmt.addToNs(ParserNamespaces.MODULE_NAME_TO_NAMESPACE, (Object)moduleName, (Object)moduleNs);
        String modulePrefix = (String)SourceException.throwIfNull((Object)((String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class)), stmt, (String)"Prefix of the module [%s] is missing", (Object[])new Object[]{moduleName});
        stmt.addToNs(ParserNamespaces.IMP_PREFIX_TO_NAMESPACE, (Object)modulePrefix, (Object)moduleNs);
        stmt.addContext(ParserNamespaces.PRELINKAGE_MODULE, (Object)moduleName, stmt);
        Revision revisionDate = StmtContextUtils.getLatestRevision((Iterable)stmt.declaredSubstatements()).orElse(null);
        QNameModule qNameModule = QNameModule.create((XMLNamespace)moduleNs, (Revision)revisionDate).intern();
        stmt.addToNs(ParserNamespaces.MODULECTX_TO_QNAME, stmt, (Object)qNameModule);
        stmt.setRootIdentifier(new SourceIdentifier((UnresolvedQName.Unqualified)stmt.getArgument(), revisionDate));
    }

    public void onLinkageDeclared(StmtContext.Mutable<UnresolvedQName.Unqualified, ModuleStatement, ModuleEffectiveStatement> stmt) {
        Revision revisionDate;
        XMLNamespace moduleNs = (XMLNamespace)SourceException.throwIfNull((Object)((XMLNamespace)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), NamespaceStatement.class)), stmt, (String)"Namespace of the module [%s] is missing", (Object[])new Object[]{stmt.argument()});
        QNameModule qNameModule = QNameModule.create((XMLNamespace)moduleNs, (Revision)(revisionDate = (Revision)StmtContextUtils.getLatestRevision((Iterable)stmt.declaredSubstatements()).orElse(null))).intern();
        StmtContext possibleDuplicateModule = (StmtContext)stmt.getFromNamespace(ParserNamespaces.NAMESPACE_TO_MODULE, (Object)qNameModule);
        if (possibleDuplicateModule != null && possibleDuplicateModule != stmt) {
            throw new SourceException(stmt, "Module namespace collision: %s. At %s", new Object[]{qNameModule.getNamespace(), possibleDuplicateModule.sourceReference()});
        }
        UnresolvedQName.Unqualified moduleName = (UnresolvedQName.Unqualified)stmt.getArgument();
        SourceIdentifier moduleIdentifier = new SourceIdentifier(moduleName, revisionDate);
        stmt.addContext(ParserNamespaces.MODULE, (Object)moduleIdentifier, stmt);
        stmt.addContext(ParserNamespaces.MODULE_FOR_BELONGSTO, (Object)moduleName, stmt);
        stmt.addContext(ParserNamespaces.NAMESPACE_TO_MODULE, (Object)qNameModule, stmt);
        String modulePrefix = (String)SourceException.throwIfNull((Object)((String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class)), stmt, (String)"Prefix of the module [%s] is missing", (Object[])new Object[]{stmt.argument()});
        stmt.addToNs(QNameModuleNamespace.INSTANCE, (Object)Empty.value(), (Object)qNameModule);
        stmt.addToNs(ParserNamespaces.PREFIX_TO_MODULE, (Object)modulePrefix, (Object)qNameModule);
        stmt.addToNs(ParserNamespaces.MODULE_NAME_TO_QNAME, (Object)moduleName, (Object)qNameModule);
        stmt.addToNs(ParserNamespaces.MODULECTX_TO_QNAME, stmt, (Object)qNameModule);
        stmt.addToNs(ParserNamespaces.MODULECTX_TO_SOURCE, stmt, (Object)moduleIdentifier);
        stmt.addToNs(ParserNamespaces.MODULE_NAMESPACE_TO_NAME, (Object)qNameModule, (Object)moduleName);
        stmt.addToNs(ParserNamespaces.IMPORT_PREFIX_TO_MODULECTX, (Object)modulePrefix, stmt);
    }

    protected ImmutableList<? extends EffectiveStatement<?, ?>> buildEffectiveSubstatements(EffectiveStmtCtx.Current<UnresolvedQName.Unqualified, ModuleStatement> stmt, List<? extends StmtContext<?, ?, ?>> substatements) {
        ImmutableList local = super.buildEffectiveSubstatements(stmt, substatements);
        Collection<StmtContext<?, ?, ?>> submodules = ModuleStatementSupport.submoduleContexts(stmt);
        if (submodules.isEmpty()) {
            return local;
        }
        ArrayList<EffectiveStatement> others = new ArrayList<EffectiveStatement>();
        for (StmtContext<?, ?, ?> submoduleCtx : submodules) {
            for (EffectiveStatement effective : submoduleCtx.buildEffective().effectiveSubstatements()) {
                if (!(effective instanceof SchemaNode) && !(effective instanceof DataNodeContainer)) continue;
                others.add(effective);
            }
        }
        return ImmutableList.builderWithExpectedSize((int)(local.size() + others.size())).addAll((Iterable)local).addAll(others).build();
    }

    protected ModuleStatement createDeclared(BoundStmtCtx<UnresolvedQName.Unqualified> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        if (substatements.isEmpty()) {
            throw ModuleStatementSupport.noNamespace(ctx);
        }
        return DeclaredStatements.createModule((String)ctx.getRawArgument(), (UnresolvedQName.Unqualified)((UnresolvedQName.Unqualified)ctx.getArgument()), substatements);
    }

    protected ModuleStatement attachDeclarationReference(ModuleStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateModule((ModuleStatement)stmt, (DeclarationReference)reference);
    }

    protected ModuleEffectiveStatement createEffective(EffectiveStmtCtx.Current<UnresolvedQName.Unqualified, ModuleStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        if (substatements.isEmpty()) {
            throw ModuleStatementSupport.noNamespace(stmt);
        }
        ArrayList<Submodule> submodules = new ArrayList<Submodule>();
        for (StmtContext<?, ?, ?> submoduleCtx : ModuleStatementSupport.submoduleContexts(stmt)) {
            EffectiveStatement submodule = submoduleCtx.buildEffective();
            Verify.verify((boolean)(submodule instanceof Submodule), (String)"Submodule statement %s is not a Submodule", (Object)submodule);
            submodules.add((Submodule)submodule);
        }
        QNameModule qnameModule = (QNameModule)Verify.verifyNotNull((Object)((QNameModule)stmt.namespaceItem(QNameModuleNamespace.INSTANCE, (Object)Empty.value())));
        try {
            return new ModuleEffectiveStatementImpl(stmt, substatements, submodules, qnameModule);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    private static Collection<StmtContext<?, ?, ?>> submoduleContexts(EffectiveStmtCtx.Current<?, ?> stmt) {
        Map submodules = stmt.localNamespacePortion(ParserNamespaces.INCLUDED_SUBMODULE_NAME_TO_MODULECTX);
        return submodules == null ? List.of() : submodules.values();
    }

    private static SourceException noNamespace(@NonNull CommonStmtCtx stmt) {
        return new SourceException("No namespace declared in module", stmt);
    }
}

