#!/bin/bash

BASE_URL=$1
TARGET_CHANNEL=$2
SITE_PATH=$3
RELEASE_BASE_PATH=$4
#$BASE_URL="https://top.etsi.org/top-extras/updatesite"

update_contents() {
    local TARGET_PATH=$1
    # Escape slashes in the variable
    CLEAN=$(echo "$TARGET_PATH" | sed 's/\//\\\//g')
    # Use the escaped variable in a sed command
    find . -type f | sed -e "s|$CLEAN_URL||g" > "$TARGET_PATH/content.txt"
}

process_contents() {
    local base="content"
    local channel=$1
    local file="$base-$channel.txt"
    curl "$BASE_URL/$channel/$base.txt" -o "$file"  
    mkdir $channel

    # Fetch files from page
    # Read each line from the file
    while IFS= read -r line; do
        # Execute your command for each line
        echo "Processing: $line"
        # make parent dirs
        mkdir -p `dirname "$line"`
        # get file
        curl "$BASE_URL/$channel/$line" -o "$channel/$line"
        # update contents
    done < "$file"
    update_contents $channel
    cp -r -f $channel/* $RELEASE_BASE_PATH/$channel
}

# process opposite channel
if [ "$TARGET_CHANNEL" == "beta"]; then
    process_contents "main"
else
    process_contents "beta"
fi

# update conteints
update_contents "$SITE_PATH"

