/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import tech.pantheon.triemap.AbstractEntrySet;
import tech.pantheon.triemap.AbstractIterator;
import tech.pantheon.triemap.AbstractKeySet;
import tech.pantheon.triemap.INode;
import tech.pantheon.triemap.ImmutableIterator;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.LookupResult;
import tech.pantheon.triemap.MutableTrieMap;
import tech.pantheon.triemap.SerializationProxy;

public abstract class TrieMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient AbstractEntrySet<K, V> entrySet;
    private transient AbstractKeySet<K> keySet;

    TrieMap() {
    }

    public static <K, V> MutableTrieMap<K, V> create() {
        return new MutableTrieMap();
    }

    public abstract MutableTrieMap<K, V> mutableSnapshot();

    public abstract ImmutableTrieMap<K, V> immutableSnapshot();

    @Override
    public final boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public final boolean containsValue(Object value) {
        return super.containsValue(Objects.requireNonNull(value));
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        AbstractEntrySet<K, V> ret = this.entrySet;
        return ret != null ? ret : (this.entrySet = this.createEntrySet());
    }

    @Override
    public final Set<K> keySet() {
        AbstractKeySet<K> ret = this.keySet;
        return ret != null ? ret : (this.keySet = this.createKeySet());
    }

    @Override
    public final V get(Object key) {
        Object k = Objects.requireNonNull(key);
        return this.lookuphc(k, TrieMap.computeHash(k));
    }

    @Override
    public abstract void clear();

    @Override
    public abstract V put(K var1, V var2);

    @Override
    public abstract V putIfAbsent(K var1, V var2);

    @Override
    public abstract V remove(Object var1);

    @Override
    public abstract boolean remove(Object var1, Object var2);

    @Override
    public abstract boolean replace(K var1, V var2, V var3);

    @Override
    public abstract V replace(K var1, V var2);

    @Override
    public abstract int size();

    abstract AbstractEntrySet<K, V> createEntrySet();

    abstract AbstractKeySet<K> createKeySet();

    abstract boolean isReadOnly();

    abstract INode<K, V> rdcssReadRoot(boolean var1);

    abstract AbstractIterator<K, V> iterator();

    final ImmutableIterator<K, V> immutableIterator() {
        return new ImmutableIterator<K, V>(this.immutableSnapshot());
    }

    static final int computeHash(Object key) {
        int hash = key.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        return hash;
    }

    final Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.immutableSnapshot(), this.isReadOnly());
    }

    final INode<K, V> readRoot() {
        return this.rdcssReadRoot(false);
    }

    final INode<K, V> readRoot(boolean abort) {
        return this.rdcssReadRoot(abort);
    }

    private V lookuphc(K key, int hc) {
        Object res;
        while ((res = this.readRoot().recLookup(key, hc, 0, null, this)) == LookupResult.RESTART) {
        }
        return (V)res;
    }
}

