/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.ModifiableMapPhase;
import org.opendaylight.yangtools.util.UnmodifiableMapPhase;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.spi.node.CloneableMap;
import org.opendaylight.yangtools.yang.data.spi.node.LazyLeafOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractImmutableDataContainerNodeBuilder<I extends YangInstanceIdentifier.PathArgument, R extends DataContainerNode>
implements DataContainerNodeBuilder<I, R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractImmutableDataContainerNodeBuilder.class);
    private static final int DEFAULT_CAPACITY = 4;
    private static final boolean USE_LINKEDHASHMAP = Boolean.getBoolean("org.opendaylight.yangtools.yang.data.impl.schema.builder.retain-child-order");
    private Map<YangInstanceIdentifier.NodeIdentifier, Object> value;
    private I nodeIdentifier;
    private boolean dirty;

    AbstractImmutableDataContainerNodeBuilder() {
        this.value = AbstractImmutableDataContainerNodeBuilder.newHashMap();
        this.dirty = false;
        this.nodeIdentifier = null;
    }

    AbstractImmutableDataContainerNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? AbstractImmutableDataContainerNodeBuilder.newHashMap(sizeHint) : AbstractImmutableDataContainerNodeBuilder.newHashMap();
        this.dirty = false;
        this.nodeIdentifier = null;
    }

    AbstractImmutableDataContainerNodeBuilder(@NonNull I name, @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifier, Object> value) {
        this.nodeIdentifier = (YangInstanceIdentifier.PathArgument)Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
        this.dirty = true;
    }

    protected final I getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    protected final @Nullable DataContainerChild getChild(YangInstanceIdentifier.NodeIdentifier child) {
        return LazyLeafOperations.getChild(this.value, child);
    }

    protected final Map<YangInstanceIdentifier.NodeIdentifier, Object> buildValue() {
        if (this.value instanceof ModifiableMapPhase) {
            return ((ModifiableMapPhase)this.value).toUnmodifiableMap();
        }
        this.dirty = true;
        return this.value;
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = this.value instanceof UnmodifiableMapPhase ? ((UnmodifiableMapPhase)this.value).toModifiableMap() : (this.value instanceof CloneableMap ? ((CloneableMap)this.value).createMutableClone() : AbstractImmutableDataContainerNodeBuilder.newHashMap(this.value));
            this.dirty = false;
        }
    }

    public DataContainerNodeBuilder<I, R> withValue(Collection<DataContainerChild> withValue) {
        for (DataContainerChild dataContainerChild : withValue) {
            this.withChild(dataContainerChild);
        }
        return this;
    }

    public DataContainerNodeBuilder<I, R> withChild(DataContainerChild child) {
        this.checkDirty();
        LazyLeafOperations.putChild(this.value, child);
        return this;
    }

    public DataContainerNodeBuilder<I, R> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        this.value.remove(key);
        return this;
    }

    public DataContainerNodeBuilder<I, R> withNodeIdentifier(I withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public DataContainerNodeBuilder<I, R> addChild(DataContainerChild child) {
        return this.withChild(child);
    }

    public NormalizedNodeContainerBuilder<I, YangInstanceIdentifier.PathArgument, DataContainerChild, R> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    private static <K, V> HashMap<K, V> newHashMap() {
        return USE_LINKEDHASHMAP ? new LinkedHashMap(4) : new HashMap(4);
    }

    private static <K, V> HashMap<K, V> newHashMap(int size) {
        return USE_LINKEDHASHMAP ? Maps.newLinkedHashMapWithExpectedSize((int)size) : Maps.newHashMapWithExpectedSize((int)size);
    }

    private static <K, V> HashMap<K, V> newHashMap(Map<K, V> map) {
        return USE_LINKEDHASHMAP ? new LinkedHashMap<K, V>(map) : new HashMap<K, V>(map);
    }

    static {
        if (USE_LINKEDHASHMAP) {
            LOG.info("Initial immutable DataContainerNodes are retaining child insertion order");
        }
    }
}

