/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.source;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.spi.source.AbstractYinTextSource;

@NonNullByDefault
public class FileYinTextSource
extends AbstractYinTextSource<Path> {
    public FileYinTextSource(SourceIdentifier sourceId, Path path) {
        super(sourceId, path);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Supplied path " + path + " is not a regular file");
        }
    }

    public FileYinTextSource(Path path) {
        this(SourceIdentifier.ofYinFileName((String)path.toFile().getName()), path);
    }

    public final InputStream openStream() throws IOException {
        return Files.newInputStream((Path)this.getDelegate(), new OpenOption[0]);
    }

    public final @NonNull String symbolicName() {
        return ((Path)this.getDelegate()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("path", this.getDelegate());
    }
}

