/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.util.AbstractSet;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.jdt.annotation.NonNull;
import tech.pantheon.triemap.TrieMap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractEntrySet<K, V, M extends TrieMap<K, V>>
extends AbstractSet<Map.Entry<K, V>> {
    final @NonNull M map;

    AbstractEntrySet(M map) {
        this.map = (TrieMap)Objects.requireNonNull(map);
    }

    @Override
    public final boolean contains(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)o;
        Object key = entry.getKey();
        if (key == null) {
            return false;
        }
        Object value = entry.getValue();
        return value != null && value.equals(((TrieMap)this.map).get(key));
    }

    @Override
    public final int size() {
        return ((TrieMap)this.map).size();
    }

    @Override
    public final Spliterator<Map.Entry<K, V>> spliterator() {
        return Spliterators.spliterator(((TrieMap)this.map).iterator(), Long.MAX_VALUE, this.characteristics());
    }

    abstract int characteristics();
}

