/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractUnqualifiedStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class BelongsToStatementSupport
extends AbstractUnqualifiedStatementSupport<BelongsToStatement, BelongsToEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.BELONGS_TO).addMandatory((StatementDefinition)YangStmtMapping.PREFIX).build();

    public BelongsToStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.BELONGS_TO, StatementSupport.StatementPolicy.reject(), config, SUBSTATEMENT_VALIDATOR);
    }

    public void onPreLinkageDeclared(StmtContext.Mutable<UnresolvedQName.Unqualified, BelongsToStatement, BelongsToEffectiveStatement> ctx) {
        ctx.addRequiredSource(new SourceIdentifier((UnresolvedQName.Unqualified)ctx.getArgument()));
    }

    public void onLinkageDeclared(final StmtContext.Mutable<UnresolvedQName.Unqualified, BelongsToStatement, BelongsToEffectiveStatement> belongsToCtx) {
        ModelActionBuilder belongsToAction = belongsToCtx.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
        final ModelActionBuilder.Prerequisite belongsToPrereq = belongsToAction.requiresCtx(belongsToCtx, ParserNamespaces.MODULE_FOR_BELONGSTO, (Object)((UnresolvedQName.Unqualified)belongsToCtx.getArgument()), ModelProcessingPhase.SOURCE_LINKAGE);
        belongsToAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                belongsToCtx.addToNs(ParserNamespaces.BELONGSTO_PREFIX_TO_MODULECTX, (Object)((String)StmtContextUtils.findFirstDeclaredSubstatement((StmtContext)belongsToCtx, PrefixStatement.class).getArgument()), (Object)((StmtContext)belongsToPrereq.resolve(ctx)));
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                if (failed.contains(belongsToPrereq)) {
                    throw new InferenceException((CommonStmtCtx)belongsToCtx, "Module '%s' from belongs-to was not found", new Object[]{belongsToCtx.argument()});
                }
            }
        });
    }

    protected BelongsToStatement createDeclared(BoundStmtCtx<UnresolvedQName.Unqualified> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createBelongsTo((UnresolvedQName.Unqualified)((UnresolvedQName.Unqualified)ctx.getArgument()), substatements);
    }

    protected BelongsToStatement attachDeclarationReference(BelongsToStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateBelongsTo((BelongsToStatement)stmt, (DeclarationReference)reference);
    }

    protected BelongsToEffectiveStatement createEffective(EffectiveStmtCtx.Current<UnresolvedQName.Unqualified, BelongsToStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createBelongsTo((BelongsToStatement)((BelongsToStatement)stmt.declared()), substatements);
    }
}

