/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YangErrorListener
extends BaseErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(YangErrorListener.class);
    private final List<YangSyntaxErrorException> exceptions = new ArrayList<YangSyntaxErrorException>();
    private final SourceIdentifier sourceId;

    YangErrorListener(SourceIdentifier sourceId) {
        this.sourceId = Objects.requireNonNull(sourceId);
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        LOG.debug("Syntax error in {} at {}:{}: {}", new Object[]{this.sourceId, line, charPositionInLine, msg, e});
        this.exceptions.add(new YangSyntaxErrorException(this.sourceId, line, charPositionInLine, msg, (Throwable)e));
    }

    void validate() throws YangSyntaxErrorException {
        if (this.exceptions.isEmpty()) {
            return;
        }
        if (this.exceptions.size() == 1) {
            throw this.exceptions.get(0);
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (YangSyntaxErrorException ex : this.exceptions) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(ex.getFormattedMessage());
        }
        throw new YangSyntaxErrorException(this.sourceId, 0, 0, sb.toString());
    }
}

