/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderUtils.class);
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');

    private ClassLoaderUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public static <T, R> R applyWithClassLoader(@NonNull ClassLoader cls, @NonNull Function<T, R> function, T input) {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCls = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(Objects.requireNonNull(cls));
        try {
            R r = Objects.requireNonNull(function).apply(input);
            return r;
        }
        finally {
            currentThread.setContextClassLoader(oldCls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public static <V> V callWithClassLoader(@NonNull ClassLoader cls, @NonNull Callable<V> callable) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCls = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(Objects.requireNonNull(cls));
        try {
            V v = Objects.requireNonNull(callable).call();
            return v;
        }
        finally {
            currentThread.setContextClassLoader(oldCls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public static <V> V getWithClassLoader(@NonNull ClassLoader cls, @NonNull Supplier<V> supplier) {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCls = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(Objects.requireNonNull(cls));
        try {
            V v = Objects.requireNonNull(supplier).get();
            return v;
        }
        finally {
            currentThread.setContextClassLoader(oldCls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public static void runWithClassLoader(@NonNull ClassLoader cls, @NonNull Runnable runnable) {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCls = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(Objects.requireNonNull(cls));
        try {
            Objects.requireNonNull(runnable).run();
        }
        finally {
            currentThread.setContextClassLoader(oldCls);
        }
    }

    public static Class<?> loadClass(ClassLoader cls, String name) throws ClassNotFoundException {
        if ("byte[]".equals(name)) {
            return byte[].class;
        }
        if ("char[]".equals(name)) {
            return char[].class;
        }
        return ClassLoaderUtils.loadClass0(cls, name);
    }

    private static Class<?> loadClass0(ClassLoader cls, String name) throws ClassNotFoundException {
        try {
            return cls.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            List components = DOT_SPLITTER.splitToList((CharSequence)name);
            if (ClassLoaderUtils.isInnerClass(components)) {
                int length = components.size() - 1;
                String outerName = DOT_JOINER.join(Iterables.limit((Iterable)components, (int)length));
                String innerName = outerName + "$" + (String)components.get(length);
                return cls.loadClass(innerName);
            }
            throw e;
        }
    }

    private static boolean isInnerClass(List<String> components) {
        int length = components.size();
        if (length < 2) {
            return false;
        }
        String potentialOuter = components.get(length - 2);
        if (potentialOuter == null) {
            return false;
        }
        return Character.isUpperCase(potentialOuter.charAt(0));
    }

    public static Class<?> loadClassWithTCCL(String name) throws ClassNotFoundException {
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        if (tccl == null) {
            throw new ClassNotFoundException("Thread " + thread + " does not have a Context Class Loader, cannot load " + name);
        }
        return ClassLoaderUtils.loadClass(tccl, name);
    }

    public static Optional<Class<?>> tryToLoadClassWithTCCL(String fullyQualifiedClassName) {
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        if (tccl == null) {
            LOG.debug("Thread {} does not have a Context Class Loader, not loading class {}", (Object)thread, (Object)fullyQualifiedClassName);
            return Optional.empty();
        }
        try {
            return Optional.of(ClassLoaderUtils.loadClass(tccl, fullyQualifiedClassName));
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Failed to load class {}", (Object)fullyQualifiedClassName, (Object)e);
            return Optional.empty();
        }
    }

    public static <S, G, P> Optional<Class<P>> findFirstGenericArgument(Class<S> scannedClass, Class<G> genericType) {
        return ClassLoaderUtils.getWithClassLoader(scannedClass.getClassLoader(), () -> ClassLoaderUtils.findParameterizedType(scannedClass, genericType).map(ptype -> (Class)ptype.getActualTypeArguments()[0]));
    }

    public static Optional<ParameterizedType> findParameterizedType(Class<?> subclass, Class<?> genericType) {
        Objects.requireNonNull(genericType);
        for (Type type : subclass.getGenericInterfaces()) {
            ParameterizedType ptype;
            if (!(type instanceof ParameterizedType) || !genericType.equals((ptype = (ParameterizedType)type).getRawType())) continue;
            return Optional.of(ptype);
        }
        LOG.debug("Class {} does not declare interface {}", subclass, genericType);
        return Optional.empty();
    }

    public static Optional<Type> getFirstGenericParameter(Type type) {
        Objects.requireNonNull(type);
        return type instanceof ParameterizedType ? Optional.of(((ParameterizedType)type).getActualTypeArguments()[0]) : Optional.empty();
    }
}

