/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.RootStmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class DeviationStatementSupport
extends AbstractStatementSupport<SchemaNodeIdentifier.Absolute, DeviationStatement, DeviationEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATION).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.DEVIATE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();

    public DeviationStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.DEVIATION, StatementSupport.StatementPolicy.reject(), config, SUBSTATEMENT_VALIDATOR);
    }

    public SchemaNodeIdentifier.Absolute parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return ArgumentUtils.parseAbsoluteSchemaNodeIdentifier(ctx, value);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<SchemaNodeIdentifier.Absolute, DeviationStatement, DeviationEffectiveStatement> ctx) {
        QNameModule targetModule;
        QNameModule currentModule;
        super.onFullDefinitionDeclared(ctx);
        RootStmtContext.Mutable root = ctx.getRoot();
        if (root.producesDeclared(SubmoduleStatement.class)) {
            root = (StmtContext)Iterables.getOnlyElement(root.getAllFromNamespace(ParserNamespaces.BELONGSTO_PREFIX_TO_MODULECTX).values());
        }
        if ((currentModule = (QNameModule)Verify.verifyNotNull((Object)((QNameModule)ctx.getFromNamespace(ParserNamespaces.MODULECTX_TO_QNAME, (Object)root)), (String)"Failed to find QName for %s", (Object[])new Object[]{root})).equals((Object)(targetModule = ((QName)Iterables.getLast((Iterable)((SchemaNodeIdentifier.Absolute)ctx.getArgument()).getNodeIdentifiers())).getModule()))) {
            throw new InferenceException(ctx, "Deviation must not target the same module as the one it is defined in: %s", new Object[]{currentModule});
        }
    }

    protected DeviationStatement createDeclared(BoundStmtCtx<SchemaNodeIdentifier.Absolute> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createDeviation((String)ctx.getRawArgument(), (SchemaNodeIdentifier.Absolute)((SchemaNodeIdentifier.Absolute)ctx.getArgument()), substatements);
    }

    protected DeviationStatement attachDeclarationReference(DeviationStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateDeviation((DeviationStatement)stmt, (DeclarationReference)reference);
    }

    protected DeviationEffectiveStatement createEffective(EffectiveStmtCtx.Current<SchemaNodeIdentifier.Absolute, DeviationStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createDeviation((DeviationStatement)((DeviationStatement)stmt.declared()), substatements);
    }
}

