/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import java.util.AbstractQueue;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import org.opendaylight.yangtools.concepts.Immutable;

public final class EmptyDeque<E>
extends AbstractQueue<E>
implements Deque<E>,
Immutable {
    private static final EmptyDeque<?> INSTANCE = new EmptyDeque();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private EmptyDeque() {
    }

    public static <T> EmptyDeque<T> instance() {
        return INSTANCE;
    }

    @Override
    public boolean offer(E e) {
        return false;
    }

    @Override
    public boolean offerFirst(E e) {
        return false;
    }

    @Override
    public boolean offerLast(E e) {
        return false;
    }

    @Override
    public E poll() {
        return null;
    }

    @Override
    public E pollFirst() {
        return null;
    }

    @Override
    public E pollLast() {
        return null;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public E peekFirst() {
        return null;
    }

    @Override
    public E peekLast() {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.emptySpliterator();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Object[] toArray() {
        return EMPTY_ARRAY;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return Objects.requireNonNull(a);
    }

    @Override
    public void addFirst(E e) {
        this.add(e);
    }

    @Override
    public void addLast(E e) {
        this.add(e);
    }

    @Override
    public E removeFirst() {
        return this.remove();
    }

    @Override
    public E removeLast() {
        return this.remove();
    }

    @Override
    public E getFirst() {
        return this.element();
    }

    @Override
    public E getLast() {
        return this.element();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return false;
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return Collections.emptyIterator();
    }
}

