/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStorage;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;

abstract class NamespaceAccess<K, V> {
    NamespaceAccess() {
    }

    abstract @NonNull ParserNamespace<K, V> namespace();

    abstract @Nullable V valueFrom(@NonNull NamespaceStorage var1, K var2);

    abstract void valueTo(@NonNull NamespaceStorage var1, K var2, V var3);

    abstract @Nullable Map<K, V> allFrom(@NonNull NamespaceStorage var1);

    abstract @Nullable Map.Entry<K, V> entryFrom(@NonNull NamespaceStorage var1, @NonNull NamespaceKeyCriterion<K> var2);

    abstract void addListener(K var1, KeyedValueAddedListener<K, V> var2);

    abstract void addListener(PredicateValueAddedListener<K, V> var1);

    @FunctionalInterface
    static interface PredicateValueAddedListener<K, V> {
        public boolean onValueAdded(@NonNull K var1, @NonNull V var2);
    }

    static abstract class KeyedValueAddedListener<K, V> {
        private final @NonNull NamespaceStorage contextNode;

        KeyedValueAddedListener(NamespaceStorage contextNode) {
            this.contextNode = Objects.requireNonNull(contextNode);
        }

        final boolean isRequestedValue(NamespaceAccess<K, ?> access, NamespaceStorage storage, K key, V value) {
            return value == access.valueFrom(this.contextNode, key);
        }

        abstract void onValueAdded(K var1, V var2);
    }
}

