/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.spi.SimpleSchemaContext;

@VisibleForTesting
public final class EffectiveSchemaContext
extends SimpleSchemaContext
implements EffectiveModelContext {
    private final ImmutableList<DeclaredStatement<?>> rootDeclaredStatements;
    private final ImmutableMap<QNameModule, ModuleEffectiveStatement> rootEffectiveStatements;

    private EffectiveSchemaContext(Set<Module> modules, List<DeclaredStatement<?>> rootDeclaredStatements, List<EffectiveStatement<?, ?>> rootEffectiveStatements) {
        super(modules);
        this.rootDeclaredStatements = ImmutableList.copyOf(rootDeclaredStatements);
        this.rootEffectiveStatements = (ImmutableMap)rootEffectiveStatements.stream().filter(ModuleEffectiveStatement.class::isInstance).map(ModuleEffectiveStatement.class::cast).collect(ImmutableMap.toImmutableMap(ModuleEffectiveStatement::localQNameModule, Function.identity()));
    }

    static EffectiveSchemaContext create(List<DeclaredStatement<?>> rootDeclaredStatements, List<EffectiveStatement<?, ?>> rootEffectiveStatements) {
        HashSet<Module> modules = new HashSet<Module>();
        for (EffectiveStatement<?, ?> stmt : rootEffectiveStatements) {
            if (!(stmt.getDeclared() instanceof ModuleStatement)) continue;
            Verify.verify((boolean)(stmt instanceof Module));
            modules.add((Module)stmt);
        }
        return new EffectiveSchemaContext(modules, rootDeclaredStatements, rootEffectiveStatements);
    }

    @VisibleForTesting
    public List<DeclaredStatement<?>> getRootDeclaredStatements() {
        return this.rootDeclaredStatements;
    }

    public ImmutableMap<QNameModule, ModuleEffectiveStatement> getModuleStatements() {
        return this.rootEffectiveStatements;
    }
}

