/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import tech.pantheon.triemap.EntryNode;
import tech.pantheon.triemap.EntryUtil;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.SNode;

final class TNode<K, V>
extends MainNode<K, V>
implements EntryNode<K, V> {
    final K key;
    final V value;
    final int hc;

    TNode(K key, V value, int hc) {
        this.key = key;
        this.value = value;
        this.hc = hc;
    }

    SNode<K, V> copyUntombed() {
        return new SNode<K, V>(this.key, this.value, this.hc);
    }

    @Override
    int trySize() {
        return 1;
    }

    @Override
    int size(ImmutableTrieMap<?, ?> ct) {
        return 1;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return EntryUtil.entryHashCode(this.key, this.value);
    }

    @Override
    @SuppressFBWarnings(value={"EQ_UNUSUAL"}, justification="Equality handled by utility methods")
    public boolean equals(Object obj) {
        return EntryUtil.entryEquals(obj, this.key, this.value);
    }

    public String toString() {
        return EntryUtil.entryToString(this.key, this.value);
    }
}

