/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.eclipse.jdt.annotation.NonNull;
import tech.pantheon.triemap.BasicNode;
import tech.pantheon.triemap.EntryNode;
import tech.pantheon.triemap.EntryUtil;
import tech.pantheon.triemap.Result;
import tech.pantheon.triemap.TNode;

final class SNode<K, V>
extends BasicNode
implements EntryNode<K, V> {
    final K key;
    final V value;
    final int hc;

    SNode(K key, V value, int hc) {
        this.key = key;
        this.value = value;
        this.hc = hc;
    }

    TNode<K, V> copyTombed() {
        return new TNode<K, V>(this.key, this.value, this.hc);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @NonNull Result<V> toResult() {
        return new Result<V>(this.value);
    }

    @Override
    public int hashCode() {
        return EntryUtil.entryHashCode(this.key, this.value);
    }

    @Override
    @SuppressFBWarnings(value={"EQ_UNUSUAL"}, justification="Equality handled by utility methods")
    public boolean equals(Object obj) {
        return EntryUtil.entryEquals(obj, this.key, this.value);
    }

    public String toString() {
        return EntryUtil.entryToString(this.key, this.value);
    }
}

