/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.InvalidSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.MissingSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.RootStmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public final class SubstatementValidator {
    private final ImmutableMap<StatementDefinition, Cardinality> cardinalityMap;
    private final ImmutableMap<StatementDefinition, Cardinality> mandatoryStatements;
    private final StatementDefinition currentStatement;

    private SubstatementValidator(Builder builder) {
        this.cardinalityMap = builder.cardinalityMap.build();
        this.currentStatement = builder.currentStatement;
        this.mandatoryStatements = ImmutableMap.copyOf((Map)Maps.filterValues(this.cardinalityMap, c -> c.getMin() > 0));
    }

    public static Builder builder(StatementDefinition currentStatement) {
        return new Builder(currentStatement);
    }

    public void validate(StmtContext<?, ?, ?> ctx) {
        HashMap<StatementDefinition, Counter> stmtCounts = new HashMap<StatementDefinition, Counter>();
        for (StmtContext<?, ?, ?> stmtContext : ctx.allSubstatements()) {
            stmtCounts.computeIfAbsent(stmtContext.publicDefinition(), key -> new Counter()).increment();
        }
        HashMap<StatementDefinition, Cardinality> missingMandatory = new HashMap<StatementDefinition, Cardinality>((Map<StatementDefinition, Cardinality>)this.mandatoryStatements);
        for (Map.Entry entry : stmtCounts.entrySet()) {
            StatementDefinition key2 = (StatementDefinition)entry.getKey();
            Cardinality cardinality = (Cardinality)this.cardinalityMap.get((Object)key2);
            int value = ((Counter)entry.getValue()).getValue();
            if (cardinality == null) {
                if (ctx.getFromNamespace(ParserNamespaces.EXTENSION, key2.getStatementName()) != null) continue;
                RootStmtContext<?, ?, ?> root = ctx.getRoot();
                throw new InvalidSubstatementException(ctx, "%s is not valid for %s. Error in module %s (%s)", key2, this.currentStatement, root.rawArgument(), ctx.getFromNamespace(ParserNamespaces.MODULECTX_TO_QNAME, root));
            }
            if (cardinality.getMin() > 0) {
                if (cardinality.getMin() > value) {
                    RootStmtContext<?, ?, ?> root = ctx.getRoot();
                    throw new InvalidSubstatementException(ctx, "Minimal count of %s for %s is %s, detected %s. Error in module %s (%s)", key2, this.currentStatement, cardinality.getMin(), value, root.rawArgument(), ctx.getFromNamespace(ParserNamespaces.MODULECTX_TO_QNAME, root));
                }
                missingMandatory.remove(key2);
            }
            if (cardinality.getMax() >= value) continue;
            RootStmtContext<?, ?, ?> root = ctx.getRoot();
            throw new InvalidSubstatementException(ctx, "Maximal count of %s for %s is %s, detected %s. Error in module %s (%s)", key2, this.currentStatement, cardinality.getMax(), value, root.rawArgument(), ctx.getFromNamespace(ParserNamespaces.MODULECTX_TO_QNAME, root));
        }
        if (!missingMandatory.isEmpty()) {
            Map.Entry entry = missingMandatory.entrySet().iterator().next();
            RootStmtContext<?, ?, ?> rootStmtContext = ctx.getRoot();
            throw new MissingSubstatementException(ctx, "%s is missing %s. Minimal count is %s. Error in module %s (%s)", this.currentStatement, entry.getKey(), ((Cardinality)entry.getValue()).getMin(), rootStmtContext.rawArgument(), ctx.getFromNamespace(ParserNamespaces.MODULECTX_TO_QNAME, rootStmtContext));
        }
    }

    public static final class Builder {
        private static final Cardinality ONE_MAX = new Cardinality(1, Integer.MAX_VALUE);
        private static final Cardinality ONE_ONE = new Cardinality(1, 1);
        private static final Cardinality ZERO_MAX = new Cardinality(0, Integer.MAX_VALUE);
        private static final Cardinality ZERO_ONE = new Cardinality(0, 1);
        private final ImmutableMap.Builder<StatementDefinition, Cardinality> cardinalityMap = ImmutableMap.builder();
        private final StatementDefinition currentStatement;

        Builder(StatementDefinition currentStatement) {
            this.currentStatement = currentStatement;
        }

        private Builder add(StatementDefinition def, Cardinality card) {
            this.cardinalityMap.put((Object)def, (Object)card);
            return this;
        }

        public Builder add(StatementDefinition def, int min, int max) {
            if (max == Integer.MAX_VALUE) {
                return this.addAtLeast(def, min);
            }
            if (min == 0) {
                return this.addAtMost(def, max);
            }
            return this.add(def, new Cardinality(min, max));
        }

        public Builder addAtLeast(StatementDefinition def, int min) {
            switch (min) {
                case 0: {
                    return this.addAny(def);
                }
                case 1: {
                    return this.addMultiple(def);
                }
            }
            return this.add(def, new Cardinality(min, Integer.MAX_VALUE));
        }

        public Builder addAtMost(StatementDefinition def, int max) {
            return max == Integer.MAX_VALUE ? this.addAny(def) : this.add(def, new Cardinality(0, max));
        }

        public Builder addAny(StatementDefinition def) {
            return this.add(def, ZERO_MAX);
        }

        public Builder addMandatory(StatementDefinition def) {
            return this.add(def, ONE_ONE);
        }

        public Builder addMultiple(StatementDefinition def) {
            return this.add(def, ONE_MAX);
        }

        public Builder addOptional(StatementDefinition def) {
            return this.add(def, ZERO_ONE);
        }

        public SubstatementValidator build() {
            return new SubstatementValidator(this);
        }
    }

    private static final class Counter {
        private int value;

        private Counter() {
        }

        void increment() {
            ++this.value;
        }

        int getValue() {
            return this.value;
        }
    }

    private static final class Cardinality {
        private final int min;
        private final int max;

        Cardinality(int min, int max) {
            Preconditions.checkArgument((min >= 0 ? 1 : 0) != 0, (String)"Min %s cannot be less than 0!", (int)min);
            Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (String)"Min %s can not be greater than max %s!", (int)min, (int)max);
            this.min = min;
            this.max = max;
        }

        int getMax() {
            return this.max;
        }

        int getMin() {
            return this.min;
        }
    }
}

