/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public enum ModelProcessingPhase {
    INIT,
    SOURCE_PRE_LINKAGE(INIT, 2),
    SOURCE_LINKAGE(SOURCE_PRE_LINKAGE, 3),
    STATEMENT_DEFINITION(SOURCE_LINKAGE, 4),
    FULL_DECLARATION(STATEMENT_DEFINITION, 5),
    EFFECTIVE_MODEL(FULL_DECLARATION, 6);

    private static final ModelProcessingPhase[] BY_EXECUTION_ORDER;
    private final @Nullable ModelProcessingPhase previousPhase;
    private final byte executionOrder;

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/743")
    private ModelProcessingPhase() {
        this.previousPhase = null;
        this.executionOrder = 1;
    }

    private ModelProcessingPhase(ModelProcessingPhase previousPhase, int executionOrder) {
        this.previousPhase = Objects.requireNonNull(previousPhase);
        this.executionOrder = (byte)executionOrder;
    }

    public @Nullable ModelProcessingPhase getPreviousPhase() {
        return this.previousPhase;
    }

    public boolean isCompletedBy(@Nullable ModelProcessingPhase other) {
        return other != null && this.ordinal() <= other.ordinal();
    }

    public byte executionOrder() {
        return this.executionOrder;
    }

    public static @Nullable ModelProcessingPhase ofExecutionOrder(byte executionOrder) {
        try {
            return BY_EXECUTION_ORDER[executionOrder];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        ModelProcessingPhase[] values = ModelProcessingPhase.values();
        ModelProcessingPhase[] tmp = new ModelProcessingPhase[values.length + 1];
        for (ModelProcessingPhase phase : values) {
            byte offset = phase.executionOrder;
            Verify.verify((offset > 0 ? 1 : 0) != 0, (String)"Invalid execution order in %s", (Object)((Object)phase));
            ModelProcessingPhase existing = tmp[offset];
            Verify.verify((existing == null ? 1 : 0) != 0, (String)"Execution order %s clash with %s", (int)offset, (Object)((Object)existing));
            Verify.verify((tmp[offset - 1] == phase.previousPhase ? 1 : 0) != 0, (String)"Illegal previous phase of %s", (Object)((Object)phase));
            tmp[offset] = phase;
        }
        BY_EXECUTION_ORDER = tmp;
    }

    public static final class ExecutionOrder {
        public static final byte NULL = 0;
        public static final byte INIT = 1;
        public static final byte SOURCE_PRE_LINKAGE = 2;
        public static final byte SOURCE_LINKAGE = 3;
        public static final byte STATEMENT_DEFINITION = 4;
        public static final byte FULL_DECLARATION = 5;
        public static final byte EFFECTIVE_MODEL = 6;

        private ExecutionOrder() {
        }
    }
}

