/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

@Beta
public abstract class AbstractInternedStatementSupport<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends AbstractStatementSupport<A, D, E> {
    private final LoadingCache<A, D> declaredCache = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<A, D>(){

        public D load(A key) {
            return AbstractInternedStatementSupport.this.createEmptyDeclared(key);
        }
    });
    private final LoadingCache<D, E> effectiveCache = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<D, E>(){

        public E load(D key) {
            return AbstractInternedStatementSupport.this.createEmptyEffective(key);
        }
    });

    protected AbstractInternedStatementSupport(StatementDefinition publicDefinition, StatementSupport.StatementPolicy<A, D> policy, YangParserConfiguration config, @Nullable SubstatementValidator validator) {
        super(publicDefinition, policy, config, validator);
    }

    @Override
    protected final D createDeclared(BoundStmtCtx<A> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        A argument = ctx.getArgument();
        return (D)(substatements.isEmpty() ? (DeclaredStatement)this.declaredCache.getUnchecked(ctx.getArgument()) : this.createDeclared(argument, substatements));
    }

    protected abstract @NonNull D createDeclared(@NonNull A var1, @NonNull ImmutableList<DeclaredStatement<?>> var2);

    protected abstract @NonNull D createEmptyDeclared(@NonNull A var1);

    @Override
    protected final E createEffective(EffectiveStmtCtx.Current<A, D> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return (E)(substatements.isEmpty() ? (EffectiveStatement)this.effectiveCache.getUnchecked((Object)stmt.declared()) : this.createEffective(stmt.declared(), substatements));
    }

    protected abstract @NonNull E createEffective(@NonNull D var1, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> var2);

    protected abstract @NonNull E createEmptyEffective(@NonNull D var1);
}

