/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.source;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.spi.source.YinXmlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class YinDomSource
implements YinXmlSource {
    private static final Logger LOG = LoggerFactory.getLogger(YinDomSource.class);
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final QName REVISION_STMT = YangStmtMapping.REVISION.getStatementName();
    private static final String MODULE_ARG = ((ArgumentDefinition)YangStmtMapping.MODULE.getArgumentDefinition().orElseThrow()).argumentName().getLocalName();
    private static final String REVISION_ARG = ((ArgumentDefinition)YangStmtMapping.REVISION.getArgumentDefinition().orElseThrow()).argumentName().getLocalName();

    public static @NonNull YinDomSource create(@NonNull SourceIdentifier identifier, @NonNull DOMSource source, @Nullable String symbolicName) {
        SourceIdentifier id;
        Node root = source.getNode().getFirstChild();
        String rootNs = root.getNamespaceURI();
        if (rootNs == null) {
            return new Simple(identifier, source, symbolicName);
        }
        QName qname = QName.create((String)rootNs, (String)root.getLocalName());
        Preconditions.checkArgument((boolean)YangConstants.RFC6020_YIN_MODULE.equals((Object)qname.getModule()), (String)"Root node namepsace %s does not match %s", (Object)rootNs, (Object)YangConstants.RFC6020_YIN_NAMESPACE);
        Preconditions.checkArgument((YangStmtMapping.MODULE.getStatementName().equals((Object)qname) || YangStmtMapping.SUBMODULE.getStatementName().equals((Object)qname) ? 1 : 0) != 0, (String)"Root element %s is not a module nor a submodule", (Object)qname);
        Preconditions.checkArgument((boolean)(root instanceof Element), (String)"Root node %s is not an element", (Object)root);
        Element element = (Element)root;
        Attr nameAttr = element.getAttributeNode(MODULE_ARG);
        Preconditions.checkArgument((nameAttr != null ? 1 : 0) != 0, (String)"No %s name argument found in %s", (Object)element.getLocalName());
        NodeList revisions = element.getElementsByTagNameNS(REVISION_STMT.getNamespace().toString(), REVISION_STMT.getLocalName());
        if (revisions.getLength() == 0) {
            return new Simple(identifier, source, symbolicName);
        }
        Element revisionStmt = (Element)revisions.item(0);
        Attr dateAttr = revisionStmt.getAttributeNode(REVISION_ARG);
        Preconditions.checkArgument((dateAttr != null ? 1 : 0) != 0, (String)"No revision statement argument found in %s", (Object)revisionStmt);
        SourceIdentifier parsedId = new SourceIdentifier(nameAttr.getValue(), dateAttr.getValue());
        if (!parsedId.equals((Object)identifier)) {
            LOG.debug("Changed identifier from {} to {}", (Object)identifier, (Object)parsedId);
            id = parsedId;
        } else {
            id = identifier;
        }
        return new Simple(id, source, symbolicName);
    }

    public static @NonNull YinDomSource lazyTransform(YinXmlSource xmlSchemaSource) {
        YinDomSource cast = YinDomSource.castSchemaSource(xmlSchemaSource);
        return cast != null ? cast : new Transforming(xmlSchemaSource);
    }

    public static @NonNull YinDomSource transform(YinXmlSource xmlSchemaSource) throws TransformerException {
        YinDomSource cast = YinDomSource.castSchemaSource(xmlSchemaSource);
        return cast != null ? cast : YinDomSource.create(xmlSchemaSource.sourceId(), YinDomSource.transformSource(xmlSchemaSource.getSource()), xmlSchemaSource.symbolicName());
    }

    public final Class<YinDomSource> getType() {
        return YinDomSource.class;
    }

    @Override
    public abstract DOMSource getSource();

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).add("sourceId", (Object)this.sourceId())).toString();
    }

    protected abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);

    static @NonNull DOMSource transformSource(Source source) throws TransformerException {
        DOMResult result = new DOMResult();
        TRANSFORMER_FACTORY.newTransformer().transform(source, result);
        return new DOMSource(result.getNode(), result.getSystemId());
    }

    private static @Nullable YinDomSource castSchemaSource(YinXmlSource xmlSchemaSource) {
        if (xmlSchemaSource instanceof YinDomSource) {
            YinDomSource yinDom = (YinDomSource)xmlSchemaSource;
            return yinDom;
        }
        Source source = xmlSchemaSource.getSource();
        if (source instanceof DOMSource) {
            DOMSource dom = (DOMSource)source;
            return YinDomSource.create(xmlSchemaSource.sourceId(), dom, xmlSchemaSource.symbolicName());
        }
        return null;
    }

    private static final class Simple
    extends YinDomSource {
        private final @NonNull SourceIdentifier sourceId;
        private final @NonNull DOMSource source;
        private final String symbolicName;

        Simple(@NonNull SourceIdentifier sourceId, @NonNull DOMSource source, @Nullable String symbolicName) {
            this.sourceId = Objects.requireNonNull(sourceId);
            this.source = Objects.requireNonNull(source);
            this.symbolicName = symbolicName;
        }

        public SourceIdentifier sourceId() {
            return this.sourceId;
        }

        @Override
        public DOMSource getSource() {
            return this.source;
        }

        public String symbolicName() {
            return this.symbolicName;
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return toStringHelper.add("source", (Object)this.source);
        }
    }

    private static final class Transforming
    extends YinDomSource {
        private final YinXmlSource xmlSchemaSource;
        private volatile DOMSource source;

        Transforming(YinXmlSource xmlSchemaSource) {
            this.xmlSchemaSource = Objects.requireNonNull(xmlSchemaSource);
        }

        public SourceIdentifier sourceId() {
            return this.xmlSchemaSource.sourceId();
        }

        public String symbolicName() {
            return this.xmlSchemaSource.symbolicName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DOMSource getSource() {
            DOMSource ret = this.source;
            if (ret == null) {
                Transforming transforming = this;
                synchronized (transforming) {
                    ret = this.source;
                    if (ret == null) {
                        try {
                            ret = Transforming.transformSource(this.xmlSchemaSource.getSource());
                        }
                        catch (TransformerException e) {
                            throw new IllegalStateException("Failed to transform schema source " + this.xmlSchemaSource, e);
                        }
                        this.source = ret;
                    }
                }
            }
            return ret;
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return toStringHelper.add("xmlSchemaSource", (Object)this.xmlSchemaSource);
        }
    }
}

