/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.source;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.spi.source.AbstractYinTextSource;

@NonNullByDefault
public class URLYinTextSource
extends AbstractYinTextSource<URL> {
    public URLYinTextSource(SourceIdentifier sourceId, URL url) {
        super(sourceId, url);
    }

    public URLYinTextSource(URL url) {
        this(SourceIdentifier.ofYinFileName((String)URLYinTextSource.extractFileName(url.getPath())), url);
    }

    public final InputStream openStream() throws IOException {
        return ((URL)this.getDelegate()).openStream();
    }

    public final @NonNull String symbolicName() {
        return ((URL)this.getDelegate()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("url", this.getDelegate());
    }

    private static String extractFileName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

