/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractIndexedEffectiveStatement;

@Beta
public abstract class AbstractUndeclaredEffectiveStatement<A, D extends DeclaredStatement<A>>
extends AbstractIndexedEffectiveStatement<A, D> {
    public final D getDeclared() {
        return null;
    }

    public static abstract class DefaultWithDataTree<A, D extends DeclaredStatement<A>>
    extends WithDataTree<A, D> {
        private final @NonNull Map<QName, SchemaTreeEffectiveStatement<?>> schemaTree;
        private final @NonNull Map<QName, DataTreeEffectiveStatement<?>> dataTree;
        private final @NonNull Object substatements;

        protected DefaultWithDataTree(ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
            Map<QName, SchemaTreeEffectiveStatement<?>> schema = DefaultWithDataTree.createSchemaTreeNamespace(substatements);
            this.schemaTree = DefaultWithDataTree.immutableNamespaceOf(schema);
            this.dataTree = DefaultWithDataTree.createDataTreeNamespace(schema.values(), this.schemaTree);
            this.substatements = DefaultWithDataTree.maskList(substatements);
        }

        protected DefaultWithDataTree(DefaultWithDataTree<A, D> original) {
            this.schemaTree = original.schemaTree;
            this.dataTree = original.dataTree;
            this.substatements = original.substatements;
        }

        @Override
        public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
            return DefaultWithDataTree.unmaskList((Object)this.substatements);
        }

        public final Collection<SchemaTreeEffectiveStatement<?>> schemaTreeNodes() {
            return this.schemaTree.values();
        }

        public final Optional<SchemaTreeEffectiveStatement<?>> findSchemaTreeNode(QName qname) {
            return DefaultWithDataTree.findValue(this.schemaTree, (Object)qname);
        }

        public final Collection<DataTreeEffectiveStatement<?>> dataTreeNodes() {
            return this.dataTree.values();
        }

        public final Optional<DataTreeEffectiveStatement<?>> findDataTreeNode(QName qname) {
            return DefaultWithDataTree.findValue(this.dataTree, (Object)qname);
        }
    }

    public static abstract class DefaultWithSchemaTree<A, D extends DeclaredStatement<A>>
    extends WithSchemaTree<A, D> {
        private final @NonNull Map<QName, SchemaTreeEffectiveStatement<?>> schemaTree;
        private final @NonNull Object substatements;

        protected DefaultWithSchemaTree(ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
            this.substatements = DefaultWithSchemaTree.maskList(substatements);
            this.schemaTree = DefaultWithSchemaTree.immutableNamespaceOf(DefaultWithSchemaTree.createSchemaTreeNamespace(substatements));
        }

        protected DefaultWithSchemaTree(DefaultWithSchemaTree<A, D> original) {
            this.schemaTree = original.schemaTree;
            this.substatements = original.substatements;
        }

        @Override
        public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
            return DefaultWithSchemaTree.unmaskList((Object)this.substatements);
        }

        public final Collection<SchemaTreeEffectiveStatement<?>> schemaTreeNodes() {
            return this.schemaTree.values();
        }
    }

    public static abstract class WithDataTree<A, D extends DeclaredStatement<A>>
    extends WithSchemaTree<A, D>
    implements DataTreeAwareEffectiveStatement<A, D> {
    }

    public static abstract class WithSchemaTree<A, D extends DeclaredStatement<A>>
    extends AbstractUndeclaredEffectiveStatement<A, D>
    implements SchemaTreeAwareEffectiveStatement<A, D> {
        protected final @Nullable DataSchemaNode dataSchemaNode(QName name) {
            Verify.verify((boolean)(this instanceof DataNodeContainer));
            return WithSchemaTree.filterOptional((Optional)this.findSchemaTreeNode(name), DataSchemaNode.class).orElse(null);
        }
    }
}

