/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.TypeAwareCodec;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnknownTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodecFactory<T extends TypeAwareCodec<?, ?, ?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCodecFactory.class);
    private final @NonNull EffectiveModelContext modelContext;
    private final @NonNull CodecCache<T> cache;

    protected AbstractCodecFactory(@NonNull EffectiveModelContext modelContext, @NonNull CodecCache<T> cache) {
        this.modelContext = Objects.requireNonNull(modelContext);
        this.cache = Objects.requireNonNull(cache);
    }

    public final <S extends TypeAware & SchemaNode> @NonNull T codecFor(S schema, LeafrefResolver resolver) {
        TypeDefinition type = schema.getType();
        TypeAwareCodec ret = (TypeAwareCodec)this.cache.lookupSimple(type);
        if (ret != null) {
            LOG.trace("Type {} hit simple {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = (TypeAwareCodec)this.cache.lookupComplex(schema);
        if (ret != null) {
            LOG.trace("Type {} hit complex {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = this.getSimpleCodecFor(type);
        if (ret != null) {
            LOG.trace("Type {} miss simple {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = this.createComplexCodecFor(schema, type, resolver);
        LOG.trace("Type {} miss complex {}", (Object)type, (Object)ret);
        return (T)this.cache.getComplex(schema, ret);
    }

    public final @NonNull EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    protected abstract T binaryCodec(BinaryTypeDefinition var1);

    protected abstract T booleanCodec(BooleanTypeDefinition var1);

    protected abstract T bitsCodec(BitsTypeDefinition var1);

    protected abstract T emptyCodec(EmptyTypeDefinition var1);

    protected abstract T enumCodec(EnumTypeDefinition var1);

    protected abstract T identityRefCodec(IdentityrefTypeDefinition var1, QNameModule var2);

    protected abstract T instanceIdentifierCodec(InstanceIdentifierTypeDefinition var1);

    public abstract @NonNull TypeAwareCodec<YangInstanceIdentifier, ?, ?> instanceIdentifierCodec();

    protected abstract T int8Codec(Int8TypeDefinition var1);

    protected abstract T int16Codec(Int16TypeDefinition var1);

    protected abstract T int32Codec(Int32TypeDefinition var1);

    protected abstract T int64Codec(Int64TypeDefinition var1);

    protected abstract T decimalCodec(DecimalTypeDefinition var1);

    protected abstract T stringCodec(StringTypeDefinition var1);

    protected abstract T uint8Codec(Uint8TypeDefinition var1);

    protected abstract T uint16Codec(Uint16TypeDefinition var1);

    protected abstract T uint32Codec(Uint32TypeDefinition var1);

    protected abstract T uint64Codec(Uint64TypeDefinition var1);

    protected abstract T unionCodec(UnionTypeDefinition var1, List<T> var2);

    protected abstract T unknownCodec(UnknownTypeDefinition var1);

    private T getSimpleCodecFor(TypeDefinition<?> type) {
        T ret;
        if (type instanceof EmptyTypeDefinition) {
            EmptyTypeDefinition emptyType = (EmptyTypeDefinition)type;
            return this.emptyCodec(emptyType);
        }
        if (type instanceof UnknownTypeDefinition) {
            UnknownTypeDefinition unknownType = (UnknownTypeDefinition)type;
            return this.unknownCodec(unknownType);
        }
        if (type instanceof StringTypeDefinition) {
            StringTypeDefinition stringType = (StringTypeDefinition)type;
            ret = this.stringCodec(stringType);
        } else if (type instanceof Int8TypeDefinition) {
            Int8TypeDefinition int8type = (Int8TypeDefinition)type;
            ret = this.int8Codec(int8type);
        } else if (type instanceof Int16TypeDefinition) {
            Int16TypeDefinition int16type = (Int16TypeDefinition)type;
            ret = this.int16Codec(int16type);
        } else if (type instanceof Int32TypeDefinition) {
            Int32TypeDefinition int32type = (Int32TypeDefinition)type;
            ret = this.int32Codec(int32type);
        } else if (type instanceof Int64TypeDefinition) {
            Int64TypeDefinition int64type = (Int64TypeDefinition)type;
            ret = this.int64Codec(int64type);
        } else if (type instanceof Uint8TypeDefinition) {
            Uint8TypeDefinition uint8type = (Uint8TypeDefinition)type;
            ret = this.uint8Codec(uint8type);
        } else if (type instanceof Uint16TypeDefinition) {
            Uint16TypeDefinition uint16type = (Uint16TypeDefinition)type;
            ret = this.uint16Codec(uint16type);
        } else if (type instanceof Uint32TypeDefinition) {
            Uint32TypeDefinition uint32type = (Uint32TypeDefinition)type;
            ret = this.uint32Codec(uint32type);
        } else if (type instanceof Uint64TypeDefinition) {
            Uint64TypeDefinition uint64type = (Uint64TypeDefinition)type;
            ret = this.uint64Codec(uint64type);
        } else if (type instanceof BooleanTypeDefinition) {
            BooleanTypeDefinition booleanType = (BooleanTypeDefinition)type;
            ret = this.booleanCodec(booleanType);
        } else if (type instanceof DecimalTypeDefinition) {
            DecimalTypeDefinition decimalType = (DecimalTypeDefinition)type;
            ret = this.decimalCodec(decimalType);
        } else if (type instanceof EnumTypeDefinition) {
            EnumTypeDefinition enumType = (EnumTypeDefinition)type;
            ret = this.enumCodec(enumType);
        } else if (type instanceof BitsTypeDefinition) {
            BitsTypeDefinition bitsType = (BitsTypeDefinition)type;
            ret = this.bitsCodec(bitsType);
        } else if (type instanceof UnionTypeDefinition) {
            UnionTypeDefinition unionType = (UnionTypeDefinition)type;
            if (!AbstractCodecFactory.isSimpleUnion(unionType)) {
                return null;
            }
            ret = this.createSimpleUnion(unionType);
        } else if (type instanceof BinaryTypeDefinition) {
            BinaryTypeDefinition binaryType = (BinaryTypeDefinition)type;
            ret = this.binaryCodec(binaryType);
        } else {
            if (type instanceof InstanceIdentifierTypeDefinition) {
                InstanceIdentifierTypeDefinition iidType = (InstanceIdentifierTypeDefinition)type;
                return this.instanceIdentifierCodec(iidType);
            }
            return null;
        }
        return (T)this.cache.getSimple(type, (TypeAwareCodec)Verify.verifyNotNull(ret));
    }

    private static boolean isSimpleUnion(UnionTypeDefinition union) {
        for (TypeDefinition t : union.getTypes()) {
            UnionTypeDefinition unionType;
            if (!(t instanceof IdentityrefTypeDefinition) && !(t instanceof LeafrefTypeDefinition) && (!(t instanceof UnionTypeDefinition) || AbstractCodecFactory.isSimpleUnion(unionType = (UnionTypeDefinition)t))) continue;
            LOG.debug("Type {} has non-simple subtype", (Object)t);
            return false;
        }
        LOG.debug("Type {} is simple", (Object)union);
        return true;
    }

    private T createComplexCodecFor(SchemaNode schema, TypeDefinition<?> type, LeafrefResolver resolver) {
        if (type instanceof UnionTypeDefinition) {
            UnionTypeDefinition union = (UnionTypeDefinition)type;
            return this.createComplexUnion(schema, union, resolver);
        }
        if (type instanceof LeafrefTypeDefinition) {
            LeafrefTypeDefinition leafref = (LeafrefTypeDefinition)type;
            TypeDefinition target = resolver.resolveLeafref(leafref);
            T ret = this.getSimpleCodecFor(target);
            return ret != null ? ret : this.createComplexCodecFor(schema, target, resolver);
        }
        if (type instanceof IdentityrefTypeDefinition) {
            IdentityrefTypeDefinition identityref = (IdentityrefTypeDefinition)type;
            return this.identityRefCodec(identityref, schema.getQName().getModule());
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private T createSimpleUnion(UnionTypeDefinition union) {
        List types = union.getTypes();
        ArrayList<TypeAwareCodec> codecs = new ArrayList<TypeAwareCodec>(types.size());
        for (TypeDefinition type : types) {
            TypeAwareCodec codec = (TypeAwareCodec)this.cache.lookupSimple(type);
            if (codec == null) {
                codec = (TypeAwareCodec)Verify.verifyNotNull(this.getSimpleCodecFor(type), (String)"Type %s did not resolve to a simple codec", (Object[])new Object[]{type});
            }
            codecs.add(codec);
        }
        return (T)this.unionCodec(union, codecs);
    }

    private T createComplexUnion(SchemaNode schema, UnionTypeDefinition union, LeafrefResolver resolver) {
        List types = union.getTypes();
        ArrayList<TypeAwareCodec> codecs = new ArrayList<TypeAwareCodec>(types.size());
        for (TypeDefinition type : types) {
            TypeAwareCodec codec = (TypeAwareCodec)this.cache.lookupSimple(type);
            if (codec == null && (codec = this.getSimpleCodecFor(type)) == null) {
                codec = this.createComplexCodecFor(schema, type, resolver);
            }
            codecs.add((TypeAwareCodec)Verify.verifyNotNull((Object)codec, (String)"Type %s has no codec", (Object[])new Object[]{schema, type}));
        }
        return (T)this.unionCodec(union, codecs);
    }
}

