/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import java.io.Serializable;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

public interface YangNamespaceContext
extends Immutable,
Serializable {
    public @Nullable QNameModule namespaceForPrefix(String var1);

    default public @NonNull Optional<QNameModule> findNamespaceForPrefix(String prefix) {
        return Optional.ofNullable(this.namespaceForPrefix(prefix));
    }

    public @Nullable String prefixForNamespace(QNameModule var1);

    default public @NonNull Optional<String> findPrefixForNamespace(QNameModule namespace) {
        return Optional.ofNullable(this.prefixForNamespace(namespace));
    }

    default public @NonNull QName createQName(String prefix, String localName) {
        QNameModule namespace = this.namespaceForPrefix(prefix);
        if (namespace == null) {
            throw new IllegalArgumentException("Prefix " + prefix + " is not bound");
        }
        return QName.create(namespace, localName);
    }
}

