/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.NSv1;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.XMLNamespace;

public final class QNameModule
implements Comparable<QNameModule>,
Immutable,
Serializable,
Identifier,
WritableObject {
    private static final Interner<QNameModule> INTERNER = Interners.newWeakInterner();
    private static final long serialVersionUID = 3L;
    private final @NonNull XMLNamespace namespace;
    private final @Nullable Revision revision;
    private transient int hash = 0;

    private QNameModule(XMLNamespace namespace, @Nullable Revision revision) {
        this.namespace = Objects.requireNonNull(namespace);
        this.revision = revision;
    }

    public @NonNull QNameModule intern() {
        return (QNameModule)INTERNER.intern((Object)this);
    }

    public static @NonNull QNameModule create(XMLNamespace namespace, Optional<Revision> revision) {
        return new QNameModule(namespace, revision.orElse(null));
    }

    public static @NonNull QNameModule create(XMLNamespace namespace) {
        return new QNameModule(namespace, null);
    }

    public static @NonNull QNameModule create(XMLNamespace namespace, @Nullable Revision revision) {
        return new QNameModule(namespace, revision);
    }

    public static @NonNull QNameModule readFrom(DataInput in) throws IOException {
        XMLNamespace namespace = XMLNamespace.of(in.readUTF());
        String revStr = in.readUTF();
        return new QNameModule(namespace, revStr.isEmpty() ? null : Revision.of(revStr));
    }

    public @NonNull XMLNamespace getNamespace() {
        return this.namespace;
    }

    public @NonNull Optional<Revision> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    @Override
    public int compareTo(QNameModule o) {
        int cmp = this.namespace.compareTo(o.namespace);
        return cmp != 0 ? cmp : Revision.compare(this.revision, o.revision);
    }

    public @NonNull QNameModule withoutRevision() {
        return this.revision == null ? this : new QNameModule(this.namespace, null);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeUTF(this.namespace.toString());
        out.writeUTF(this.revision == null ? "" : this.revision.toString());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.namespace, this.revision);
        }
        return this.hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof QNameModule)) return false;
        QNameModule other = (QNameModule)obj;
        if (!Objects.equals(this.revision, other.revision)) return false;
        if (!this.namespace.equals(other.namespace)) return false;
        return true;
    }

    public @NonNull String toString() {
        return MoreObjects.toStringHelper(QNameModule.class).omitNullValues().add("ns", (Object)this.namespace).add("rev", (Object)this.revision).toString();
    }

    Object writeReplace() {
        return new NSv1(this);
    }
}

