/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc6241.parser;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.rfc6241.model.api.GetFilterElementAttributesEffectiveStatement;
import org.opendaylight.yangtools.rfc6241.model.api.GetFilterElementAttributesStatement;
import org.opendaylight.yangtools.rfc6241.model.api.NetconfStatements;
import org.opendaylight.yangtools.rfc6241.parser.GetFilterElementAttributesEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc6241.parser.GetFilterElementAttributesStatementImpl;
import org.opendaylight.yangtools.rfc6241.parser.RefGetFilterElementAttributesStatement;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractEmptyStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetFilterElementAttributesStatementSupport
extends AbstractEmptyStatementSupport<GetFilterElementAttributesStatement, GetFilterElementAttributesEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(GetFilterElementAttributesStatementSupport.class);
    private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)NetconfStatements.GET_FILTER_ELEMENT_ATTRIBUTES).build();

    public GetFilterElementAttributesStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)NetconfStatements.GET_FILTER_ELEMENT_ATTRIBUTES, StatementSupport.StatementPolicy.reject(), config, VALIDATOR);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<Empty, GetFilterElementAttributesStatement, GetFilterElementAttributesEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        if (!GetFilterElementAttributesStatementSupport.computeSupported(stmt)) {
            stmt.setUnsupported();
        }
    }

    protected GetFilterElementAttributesStatement createDeclared(BoundStmtCtx<Empty> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return substatements.isEmpty() ? GetFilterElementAttributesStatementImpl.EMPTY : new GetFilterElementAttributesStatementImpl(substatements);
    }

    protected GetFilterElementAttributesStatement attachDeclarationReference(GetFilterElementAttributesStatement stmt, DeclarationReference reference) {
        return new RefGetFilterElementAttributesStatement(stmt, reference);
    }

    protected GetFilterElementAttributesEffectiveStatement createEffective(EffectiveStmtCtx.Current<Empty, GetFilterElementAttributesStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new GetFilterElementAttributesEffectiveStatementImpl(stmt, substatements);
    }

    private static boolean computeSupported(StmtContext<?, ?, ?> stmt) {
        StmtContext parent = stmt.getParentContext();
        if (parent == null) {
            LOG.debug("No parent, ignoring get-filter-element-attributes statement");
            return false;
        }
        if (parent.publicDefinition() != YangStmtMapping.ANYXML) {
            LOG.debug("Parent is not an anyxml node, ignoring get-filter-element-attributes statement");
            return false;
        }
        if (!"filter".equals(parent.rawArgument())) {
            LOG.debug("Parent is not named 'filter', ignoring get-filter-element-attributes statement");
            return false;
        }
        StmtContext grandParent = parent.getParentContext();
        if (grandParent == null) {
            LOG.debug("No grandparent, ignoring get-filter-element-attributes statement");
            return false;
        }
        if (grandParent.publicDefinition() != YangStmtMapping.INPUT) {
            LOG.debug("Grandparent is not an input node, ignoring get-filter-element-attributes statement");
            return false;
        }
        StmtContext greatGrandParent = grandParent.getParentContext();
        if (greatGrandParent == null) {
            LOG.debug("No grandparent, ignoring get-filter-element-attributes statement");
            return false;
        }
        if (greatGrandParent.publicDefinition() != YangStmtMapping.RPC) {
            LOG.debug("Grandparent is not an RPC node, ignoring get-filter-element-attributes statement");
            return false;
        }
        return switch (greatGrandParent.getRawArgument()) {
            case "get", "get-config" -> true;
            default -> {
                LOG.debug("Great-grandparent is not named 'get' nor 'get-config, ignoring get-filter-element-attributes statement");
                yield false;
            }
        };
    }
}

