/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public final class YangInstanceIdentifierWriter
implements AutoCloseable {
    private NormalizedNodeStreamWriter writer;
    private final int endNodeCount;

    private YangInstanceIdentifierWriter(NormalizedNodeStreamWriter writer, int endNodeCount) {
        this.writer = Objects.requireNonNull(writer);
        this.endNodeCount = endNodeCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static @NonNull YangInstanceIdentifierWriter open(NormalizedNodeStreamWriter writer, DataNodeContainer root, YangInstanceIdentifier path) throws IOException {
        Iterator<YangInstanceIdentifier.PathArgument> it = path.getPathArguments().iterator();
        if (!it.hasNext()) {
            return new YangInstanceIdentifierWriter(writer, 0);
        }
        int endNodes = 0;
        DataNodeContainer parent = root;
        boolean reuse = false;
        boolean terminal = false;
        do {
            if (terminal) {
                throw new IOException(parent + " is a terminal node, cannot resolve " + ImmutableList.copyOf(it));
            }
            YangInstanceIdentifier.PathArgument arg = it.next();
            if (arg instanceof YangInstanceIdentifier.NodeWithValue) {
                YangInstanceIdentifier.NodeWithValue nodeId = (YangInstanceIdentifier.NodeWithValue)arg;
                if (!(parent instanceof LeafListSchemaNode)) {
                    throw new IOException(parent + " does not support leaf-list entry " + arg);
                }
                if (!reuse) {
                    throw new IOException(parent + " is already at its entry, cannot enter " + arg);
                }
                reuse = false;
                terminal = true;
                writer.startLeafSetEntryNode(nodeId);
            } else if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                YangInstanceIdentifier.NodeIdentifierWithPredicates nodeId = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
                if (!(parent instanceof ListSchemaNode)) {
                    throw new IOException(parent + " does not support map entry " + arg);
                }
                list = (ListSchemaNode)parent;
                if (!reuse) {
                    throw new IOException(parent + " is already at its entry, cannot enter " + arg);
                }
                if (!list.getQName().equals((Object)nodeId.getNodeType())) {
                    throw new IOException(parent + " expects a matching map entry, cannot enter " + arg);
                }
                List key = list.getKeyDefinition();
                if (key.isEmpty()) {
                    throw new IOException(parent + " does not expect map entry " + arg);
                }
                if (key.size() != nodeId.size()) {
                    throw new IOException(parent + " expects " + key.size() + " predicates, cannot use " + arg);
                }
                reuse = false;
                writer.startMapEntryNode(YangInstanceIdentifierWriter.normalizePredicates(nodeId, key), 1);
            } else {
                DataSchemaNode child;
                if (!(arg instanceof YangInstanceIdentifier.NodeIdentifier)) throw new IOException("Unhandled argument " + arg);
                YangInstanceIdentifier.NodeIdentifier nodeId = (YangInstanceIdentifier.NodeIdentifier)arg;
                if (reuse) {
                    if (!(parent instanceof ListSchemaNode)) {
                        throw new IOException(parent + " expects an identifiable entry, cannot enter " + arg);
                    }
                    list = (ListSchemaNode)parent;
                    if (!list.getKeyDefinition().isEmpty()) {
                        throw new IOException(parent + " expects a map entry, cannot enter " + arg);
                    }
                    if (!list.getQName().equals((Object)nodeId.getNodeType())) {
                        throw new IOException(parent + " expects a matching entry, cannot enter " + arg);
                    }
                    reuse = false;
                    writer.startUnkeyedListItem(nodeId, 1);
                    ++endNodes;
                    continue;
                }
                if (parent instanceof DataNodeContainer) {
                    DataNodeContainer container = parent;
                    child = container.dataChildByName(nodeId.getNodeType());
                } else {
                    if (!(parent instanceof ChoiceSchemaNode)) throw new IOException("Unhandled parent " + parent + " when looking up " + arg);
                    ChoiceSchemaNode choice = (ChoiceSchemaNode)parent;
                    child = choice.findDataSchemaChild(nodeId.getNodeType()).orElse(null);
                }
                if (child == null) {
                    throw new IOException("Failed to find child " + arg + " in parent " + parent);
                }
                if (child instanceof ContainerLike) {
                    parent = child;
                    writer.startContainerNode(nodeId, 1);
                } else if (child instanceof ListSchemaNode) {
                    ListSchemaNode list = (ListSchemaNode)child;
                    parent = child;
                    reuse = true;
                    if (list.getKeyDefinition().isEmpty()) {
                        writer.startUnkeyedList(nodeId, 1);
                    } else if (list.isUserOrdered()) {
                        writer.startOrderedMapNode(nodeId, 1);
                    } else {
                        writer.startMapNode(nodeId, 1);
                    }
                } else if (child instanceof LeafSchemaNode) {
                    parent = child;
                    terminal = true;
                    writer.startLeafNode(nodeId);
                } else if (child instanceof ChoiceSchemaNode) {
                    parent = child;
                    writer.startChoiceNode(nodeId, 1);
                } else if (child instanceof LeafListSchemaNode) {
                    LeafListSchemaNode leafList = (LeafListSchemaNode)child;
                    parent = child;
                    reuse = true;
                    if (leafList.isUserOrdered()) {
                        writer.startOrderedLeafSet(nodeId, 1);
                    } else {
                        writer.startLeafSet(nodeId, 1);
                    }
                } else if (child instanceof AnydataSchemaNode) {
                    parent = child;
                    terminal = true;
                    writer.startAnydataNode(nodeId, NormalizedAnydata.class);
                } else {
                    if (!(child instanceof AnyxmlSchemaNode)) throw new IOException("Unhandled child " + child);
                    parent = child;
                    terminal = true;
                    writer.startAnyxmlNode(nodeId, DOMSource.class);
                }
            }
            ++endNodes;
        } while (it.hasNext());
        return new YangInstanceIdentifierWriter(writer, endNodes);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            for (int i = 0; i < this.endNodeCount; ++i) {
                this.writer.endNode();
            }
            this.writer = null;
        }
    }

    private static YangInstanceIdentifier.NodeIdentifierWithPredicates normalizePredicates(YangInstanceIdentifier.NodeIdentifierWithPredicates input, List<QName> key) throws IOException {
        if (Iterables.elementsEqual(input.keySet(), key)) {
            return input;
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)key.size());
        for (QName qname : key) {
            Object value = input.getValue(qname);
            if (value == null) {
                throw new IOException("Cannot normalize " + input + " to " + key + ", missing value for " + qname);
            }
            builder.put((Object)qname, value);
        }
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of(input.getNodeType(), ImmutableOffsetMap.orderedCopyOf((Map)builder.build()));
    }
}

