/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;

abstract class AbstractIndentingNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter {
    private static final int DEFAULT_INDENT_SIZE = 2;
    private final Deque<String> indent = new ArrayDeque<String>();
    private final String indentStr;

    AbstractIndentingNormalizedNodeStreamWriter() {
        this(2);
    }

    AbstractIndentingNormalizedNodeStreamWriter(int indentSize) {
        this.indentStr = " ".repeat(indentSize);
        this.indent.push("");
    }

    private String ind() {
        return this.indent.peek();
    }

    private void decIndent() {
        this.indent.pop();
    }

    private void incIndent() {
        this.indent.push(this.ind() + this.indentStr);
    }

    @Override
    public final void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.enterUnkeyedListItem(name, this.ind());
        this.incIndent();
    }

    abstract void enterUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier var1, String var2);

    @Override
    public final void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.enterUnkeyedList(name, this.ind());
        this.incIndent();
    }

    abstract void enterUnkeyedList(YangInstanceIdentifier.NodeIdentifier var1, String var2);

    @Override
    public final void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.startMapNode(name, childSizeHint);
    }

    @Override
    public final void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.enterMapNode(name, this.ind());
        this.incIndent();
    }

    abstract void enterMapNode(YangInstanceIdentifier.NodeIdentifier var1, String var2);

    @Override
    public final void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) {
        this.enterMapEntryNode(identifier, this.ind());
        this.incIndent();
    }

    abstract void enterMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates var1, String var2);

    @Override
    public final void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.enterLeafSet(name, this.ind());
        this.incIndent();
    }

    abstract void enterLeafSet(YangInstanceIdentifier.NodeIdentifier var1, String var2);

    @Override
    public final void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.startLeafSet(name, childSizeHint);
    }

    @Override
    public final void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.enterContainerNode(name, this.ind());
        this.incIndent();
    }

    abstract void enterContainerNode(YangInstanceIdentifier.NodeIdentifier var1, String var2);

    @Override
    public final void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.enterChoiceNode(name, this.ind());
        this.incIndent();
    }

    abstract void enterChoiceNode(YangInstanceIdentifier.NodeIdentifier var1, String var2);

    @Override
    public final void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) {
        this.enterLeafSetEntryNode(name, this.ind());
        this.incIndent();
    }

    abstract void enterLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> var1, String var2);

    @Override
    public final void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.enterLeafNode(name, this.ind());
        this.incIndent();
    }

    abstract void enterLeafNode(YangInstanceIdentifier.NodeIdentifier var1, String var2);

    @Override
    public final boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) {
        this.enterAnyxmlNode(name, this.ind());
        this.incIndent();
        return true;
    }

    abstract void enterAnyxmlNode(YangInstanceIdentifier.NodeIdentifier var1, String var2);

    @Override
    public final boolean startAnydataNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) {
        this.enterAnydataNode(name, this.ind());
        this.incIndent();
        return true;
    }

    abstract void enterAnydataNode(YangInstanceIdentifier.NodeIdentifier var1, String var2);

    @Override
    public final void endNode() {
        this.decIndent();
        this.exitNode(this.ind());
    }

    abstract void exitNode(String var1);

    @Override
    public final void scalarValue(Object value) {
        this.scalarValue(value, this.ind());
    }

    abstract void scalarValue(@NonNull Object var1, String var2);

    @Override
    public final void domSourceValue(DOMSource value) {
        this.scalarValue(Objects.requireNonNull(value));
    }
}

