/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema;

import com.google.common.base.MoreObjects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.PrettyTree;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodePrettyTree;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractNormalizedNode<T extends NormalizedNode>
implements NormalizedNode,
Immutable {
    public final PrettyTree prettyTree() {
        return new NormalizedNodePrettyTree(this);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Class<T> clazz = this.implementedType();
        if (!clazz.isInstance(obj)) {
            return false;
        }
        NormalizedNode other = (NormalizedNode)clazz.cast(obj);
        return this.name().equals(other.name()) && this.valueEquals(other);
    }

    public final int hashCode() {
        return 31 * this.name().hashCode() + this.valueHashCode();
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(this.toStringClass())).toString();
    }

    protected @NonNull Class<?> toStringClass() {
        return this.getClass();
    }

    @NonNull Object toStringBody() {
        return this.body();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("name", (Object)this.name()).add("body", this.toStringBody());
    }

    protected abstract @NonNull Class<T> implementedType();

    protected abstract int valueHashCode();

    protected abstract boolean valueEquals(@NonNull T var1);
}

