/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMountPoint;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMountpoints;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ImmutableNormalizedMountpoints
implements NormalizedMountpoints {
    private final NormalizedMountPoint mountPoint;

    private ImmutableNormalizedMountpoints(NormalizedMountPoint mountPoint) {
        this.mountPoint = mountPoint;
    }

    public NormalizedMountPoint mountPoint() {
        return this.mountPoint;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements Mutable {
        private final Map<YangInstanceIdentifier.PathArgument, NormalizedMountpoints> children = new HashMap<YangInstanceIdentifier.PathArgument, NormalizedMountpoints>();
        private NormalizedMountPoint mountPoint;

        Builder() {
        }

        public @NonNull Builder withChild(YangInstanceIdentifier.PathArgument identifier, NormalizedMountpoints child) {
            this.children.put(Objects.requireNonNull(identifier), Objects.requireNonNull(child));
            return this;
        }

        public @NonNull Builder withChildren(Map<YangInstanceIdentifier.PathArgument, NormalizedMountpoints> children) {
            children.forEach(this::withChild);
            return this;
        }

        public @NonNull Builder withMountPoint(NormalizedMountPoint mountPoint) {
            this.mountPoint = Objects.requireNonNull(mountPoint);
            return this;
        }

        public @NonNull ImmutableNormalizedMountpoints build() {
            return this.children.isEmpty() ? new ImmutableNormalizedMountpoints(this.mountPoint) : new Container(this.mountPoint, this.children);
        }
    }

    private static final class Container
    extends ImmutableNormalizedMountpoints {
        private final @NonNull ImmutableMap<// Could not load outer class - annotation placement on inner may be incorrect
        YangInstanceIdentifier.PathArgument, NormalizedMountpoints> children;

        Container(NormalizedMountPoint mountPoint, Map<YangInstanceIdentifier.PathArgument, NormalizedMountpoints> children) {
            super(mountPoint);
            this.children = ImmutableMap.copyOf(children);
        }

        public Map<YangInstanceIdentifier.PathArgument, NormalizedMountpoints> getChildren() {
            return this.children;
        }
    }
}

