/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMetadata;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ImmutableNormalizedMetadata
implements NormalizedMetadata {
    private final @NonNull ImmutableMap<QName, Object> annotations;

    ImmutableNormalizedMetadata(Map<QName, Object> annotations) {
        this.annotations = ImmutableMap.copyOf(annotations);
    }

    public static final @NonNull Builder builder() {
        return new Builder();
    }

    public final ImmutableMap<QName, Object> getAnnotations() {
        return this.annotations;
    }

    public static final class Builder
    implements Mutable {
        private final Map<YangInstanceIdentifier.PathArgument, ImmutableNormalizedMetadata> children = new HashMap<YangInstanceIdentifier.PathArgument, ImmutableNormalizedMetadata>();
        private final Map<QName, Object> annotations = new HashMap<QName, Object>();

        Builder() {
        }

        public @NonNull Builder withAnnotation(QName type, Object value) {
            this.annotations.put(Objects.requireNonNull(type, "type"), Objects.requireNonNull(value, "value"));
            return this;
        }

        public @NonNull Builder withAnnotations(Map<QName, Object> annotations) {
            annotations.forEach(this::withAnnotation);
            return this;
        }

        public @NonNull Builder withChild(YangInstanceIdentifier.PathArgument pathArgument, ImmutableNormalizedMetadata child) {
            this.children.put(Objects.requireNonNull(pathArgument, "pathArgument"), Objects.requireNonNull(child, "child"));
            return this;
        }

        public @NonNull Builder withChildren(Map<YangInstanceIdentifier.PathArgument, ImmutableNormalizedMetadata> children) {
            children.forEach(this::withChild);
            return this;
        }

        public @NonNull ImmutableNormalizedMetadata build() {
            return this.children.isEmpty() ? new ImmutableNormalizedMetadata(this.annotations) : new Container(this.annotations, this.children);
        }
    }

    private static final class Container
    extends ImmutableNormalizedMetadata {
        private final @NonNull ImmutableMap<// Could not load outer class - annotation placement on inner may be incorrect
        YangInstanceIdentifier.PathArgument, NormalizedMetadata> children;

        Container(Map<QName, Object> annotations, Map<YangInstanceIdentifier.PathArgument, ImmutableNormalizedMetadata> children) {
            super(annotations);
            this.children = ImmutableMap.copyOf(children);
        }

        public ImmutableMap<YangInstanceIdentifier.PathArgument, NormalizedMetadata> getChildren() {
            return this.children;
        }
    }
}

