/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractDataStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BinaryStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BitsStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BooleanStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DecimalStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EmptyStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EnumStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.StringStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.UnionStringCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.LoggerFactory;

public abstract class TypeDefinitionAwareCodec<J, T extends TypeDefinition<T>>
extends AbstractDataStringCodec<J> {
    private static final boolean ENABLE_UNION_CODEC;
    private final @NonNull Class<J> inputClass;
    private final @NonNull T typeDefinition;

    protected TypeDefinitionAwareCodec(Class<J> outputClass, T typeDefinition) {
        this.inputClass = Objects.requireNonNull(outputClass);
        this.typeDefinition = (TypeDefinition)Objects.requireNonNull(typeDefinition);
    }

    @Override
    public final Class<J> getInputClass() {
        return this.inputClass;
    }

    protected final @NonNull T typeDefinition() {
        return this.typeDefinition;
    }

    public static TypeDefinitionAwareCodec<Object, ?> from(TypeDefinition<?> typeDefinition) {
        return TypeDefinitionAwareCodec.fromType(typeDefinition);
    }

    public static @Nullable TypeDefinitionAwareCodec<?, ?> fromType(TypeDefinition<?> typeDefinition) {
        if (typeDefinition instanceof BinaryTypeDefinition) {
            BinaryTypeDefinition binaryType = (BinaryTypeDefinition)typeDefinition;
            return BinaryStringCodec.from(binaryType);
        }
        if (typeDefinition instanceof BitsTypeDefinition) {
            BitsTypeDefinition bitsType = (BitsTypeDefinition)typeDefinition;
            return BitsStringCodec.from(bitsType);
        }
        if (typeDefinition instanceof BooleanTypeDefinition) {
            BooleanTypeDefinition booleanType = (BooleanTypeDefinition)typeDefinition;
            return BooleanStringCodec.from(booleanType);
        }
        if (typeDefinition instanceof DecimalTypeDefinition) {
            DecimalTypeDefinition decimalType = (DecimalTypeDefinition)typeDefinition;
            return DecimalStringCodec.from(decimalType);
        }
        if (typeDefinition instanceof EmptyTypeDefinition) {
            EmptyTypeDefinition emptyType = (EmptyTypeDefinition)typeDefinition;
            return new EmptyStringCodec(emptyType);
        }
        if (typeDefinition instanceof EnumTypeDefinition) {
            EnumTypeDefinition enumType = (EnumTypeDefinition)typeDefinition;
            return EnumStringCodec.from(enumType);
        }
        if (typeDefinition instanceof Int8TypeDefinition) {
            Int8TypeDefinition int8Type = (Int8TypeDefinition)typeDefinition;
            return AbstractIntegerStringCodec.from(int8Type);
        }
        if (typeDefinition instanceof Int16TypeDefinition) {
            Int16TypeDefinition int16Type = (Int16TypeDefinition)typeDefinition;
            return AbstractIntegerStringCodec.from(int16Type);
        }
        if (typeDefinition instanceof Int32TypeDefinition) {
            Int32TypeDefinition int32Type = (Int32TypeDefinition)typeDefinition;
            return AbstractIntegerStringCodec.from(int32Type);
        }
        if (typeDefinition instanceof Int64TypeDefinition) {
            Int64TypeDefinition int64Type = (Int64TypeDefinition)typeDefinition;
            return AbstractIntegerStringCodec.from(int64Type);
        }
        if (typeDefinition instanceof StringTypeDefinition) {
            StringTypeDefinition stringType = (StringTypeDefinition)typeDefinition;
            return StringStringCodec.from(stringType);
        }
        if (typeDefinition instanceof Uint8TypeDefinition) {
            Uint8TypeDefinition uint8Type = (Uint8TypeDefinition)typeDefinition;
            return AbstractIntegerStringCodec.from(uint8Type);
        }
        if (typeDefinition instanceof Uint16TypeDefinition) {
            Uint16TypeDefinition uint16Type = (Uint16TypeDefinition)typeDefinition;
            return AbstractIntegerStringCodec.from(uint16Type);
        }
        if (typeDefinition instanceof Uint32TypeDefinition) {
            Uint32TypeDefinition uint32Type = (Uint32TypeDefinition)typeDefinition;
            return AbstractIntegerStringCodec.from(uint32Type);
        }
        if (typeDefinition instanceof Uint64TypeDefinition) {
            Uint64TypeDefinition uint64Type = (Uint64TypeDefinition)typeDefinition;
            return AbstractIntegerStringCodec.from(uint64Type);
        }
        if (ENABLE_UNION_CODEC && typeDefinition instanceof UnionTypeDefinition) {
            UnionTypeDefinition unionType = (UnionTypeDefinition)typeDefinition;
            return UnionStringCodec.from(unionType);
        }
        return null;
    }

    static {
        boolean bl = ENABLE_UNION_CODEC = !Boolean.getBoolean("org.opendaylight.yangtools.yang.data.impl.codec.disable-union");
        if (!ENABLE_UNION_CODEC) {
            LoggerFactory.getLogger(TypeDefinitionAwareCodec.class).info("Support for unions is disabled");
        }
    }
}

