/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.model.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationEffectiveStatement;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationSchemaNodeAware;
import org.opendaylight.yangtools.yang.common.AnnotationName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

@Beta
public interface AnnotationSchemaNode
extends UnknownSchemaNode,
TypeAware {
    public static @NonNull Optional<AnnotationSchemaNode> find(SchemaContext context, AnnotationName name) {
        if (context instanceof AnnotationSchemaNodeAware) {
            AnnotationSchemaNodeAware aware = (AnnotationSchemaNodeAware)context;
            return aware.findAnnotation(name);
        }
        return context.findModule(name.qname().getModule()).flatMap(module -> module.getUnknownSchemaNodes().stream().filter(AnnotationSchemaNode.class::isInstance).map(AnnotationSchemaNode.class::cast).filter(annotation -> name.equals((Object)annotation.name())).findAny());
    }

    public static @NonNull Map<AnnotationName, AnnotationSchemaNode> findAll(SchemaContext context) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Module module : context.getModules()) {
            for (UnknownSchemaNode node : module.getUnknownSchemaNodes()) {
                if (!(node instanceof AnnotationSchemaNode)) continue;
                AnnotationSchemaNode annotation = (AnnotationSchemaNode)node;
                builder.put((Object)annotation.name(), (Object)annotation);
            }
        }
        return builder.build();
    }

    default public @NonNull AnnotationName name() {
        return (AnnotationName)this.asEffectiveStatement().argument();
    }

    default public QName getQName() {
        return this.name().qname();
    }

    public AnnotationEffectiveStatement asEffectiveStatement();
}

