/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Either;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;
import org.opendaylight.yangtools.yang.common.Decimal64Conversion;

@Beta
@NonNullByDefault
public class Decimal64
extends Number
implements CanonicalValue<Decimal64> {
    private static final CanonicalValueSupport<Decimal64> SUPPORT = new Support();
    private static final long serialVersionUID = 1L;
    private static final int MAX_SCALE = 18;
    private static final long[] FACTOR = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final Decimal64Conversion[] CONVERSION = Decimal64Conversion.values();
    private static final Decimal64[] MIN_VALUE;
    private static final Decimal64[] MAX_VALUE;
    private final byte offset;
    private final long value;

    @VisibleForTesting
    Decimal64(int scale, long intPart, long fracPart, boolean negative) {
        this.offset = Decimal64.offsetOf(scale);
        long bits = intPart * FACTOR[this.offset] + fracPart;
        this.value = negative ? -bits : bits;
    }

    private Decimal64(byte offset, long intPart, boolean negative) {
        this.offset = offset;
        long bits = intPart * FACTOR[offset];
        this.value = negative ? -bits : bits;
    }

    private Decimal64(byte offset, long value) {
        this.offset = offset;
        this.value = value;
    }

    protected Decimal64(Decimal64 other) {
        this(other.offset, other.value);
    }

    public static Decimal64 of(int scale, long unscaledValue) {
        return new Decimal64(Decimal64.offsetOf(scale), unscaledValue);
    }

    public static Decimal64 minValueIn(int scale) {
        return MIN_VALUE[Decimal64.offsetOf(scale)];
    }

    public static Decimal64 maxValueIn(int scale) {
        return MAX_VALUE[Decimal64.offsetOf(scale)];
    }

    public static Decimal64 valueOf(int scale, byte byteVal) {
        byte offset = Decimal64.offsetOf(scale);
        Decimal64Conversion conv = CONVERSION[offset];
        if (byteVal < conv.minByte || byteVal > conv.maxByte) {
            throw new IllegalArgumentException("Value " + byteVal + " is not in range [" + conv.minByte + ".." + conv.maxByte + "] to fit scale " + scale);
        }
        return byteVal < 0 ? new Decimal64(offset, -byteVal, true) : new Decimal64(offset, byteVal, false);
    }

    public static Decimal64 valueOf(int scale, short shortVal) {
        byte offset = Decimal64.offsetOf(scale);
        Decimal64Conversion conv = CONVERSION[offset];
        if (shortVal < conv.minShort || shortVal > conv.maxShort) {
            throw new IllegalArgumentException("Value " + shortVal + " is not in range [" + conv.minShort + ".." + conv.maxShort + "] to fit scale " + scale);
        }
        return shortVal < 0 ? new Decimal64(offset, -shortVal, true) : new Decimal64(offset, shortVal, false);
    }

    public static Decimal64 valueOf(int scale, int intVal) {
        byte offset = Decimal64.offsetOf(scale);
        Decimal64Conversion conv = CONVERSION[offset];
        if (intVal < conv.minInt || intVal > conv.maxInt) {
            throw new IllegalArgumentException("Value " + intVal + " is not in range [" + conv.minInt + ".." + conv.maxInt + "] to fit scale " + scale);
        }
        return intVal < 0 ? new Decimal64(offset, -((long)intVal), true) : new Decimal64(offset, intVal, false);
    }

    public static Decimal64 valueOf(int scale, long longVal) {
        byte offset = Decimal64.offsetOf(scale);
        Decimal64Conversion conv = CONVERSION[offset];
        if (longVal < conv.minLong || longVal > conv.maxLong) {
            throw new IllegalArgumentException("Value " + longVal + " is not in range [" + conv.minLong + ".." + conv.maxLong + "] to fit scale " + scale);
        }
        return longVal < 0L ? new Decimal64(offset, -longVal, true) : new Decimal64(offset, longVal, false);
    }

    public static Decimal64 valueOf(float floatVal, RoundingMode rounding) {
        return Decimal64.valueOf(Float.toString(floatVal));
    }

    public static Decimal64 valueOf(double doubleVal, RoundingMode rounding) {
        return Decimal64.valueOf(Double.toString(doubleVal));
    }

    public static Decimal64 valueOf(BigDecimal decimalVal) {
        return Decimal64.valueOf(decimalVal.toPlainString());
    }

    public static Decimal64 valueOf(String str) {
        Either<Decimal64, CanonicalValueViolation> variant = SUPPORT.fromString(str);
        Optional value = variant.tryFirst();
        if (value.isPresent()) {
            return (Decimal64)value.get();
        }
        Optional<String> message = ((CanonicalValueViolation)variant.getSecond()).getMessage();
        throw message.isPresent() ? new NumberFormatException(message.get()) : new NumberFormatException();
    }

    public final int scale() {
        return this.offset + 1;
    }

    public final long unscaledValue() {
        return this.value;
    }

    public Decimal64 scaleTo(int scale) {
        return this.scaleTo(scale, RoundingMode.UNNECESSARY);
    }

    public Decimal64 scaleTo(int scale, RoundingMode roundingMode) {
        RoundingMode mode = Objects.requireNonNull(roundingMode);
        byte scaleOffset = Decimal64.offsetOf(scale);
        int diff = scaleOffset - this.offset;
        if (diff == 0) {
            return this;
        }
        if (this.value == 0L) {
            return new Decimal64(scaleOffset, 0L);
        }
        if (diff > 0) {
            int diffOffset = diff - 1;
            Decimal64Conversion conv = CONVERSION[diffOffset];
            if (this.value < conv.minLong || this.value > conv.maxLong) {
                throw new ArithmeticException("Increasing scale of " + this + " to " + scale + " would overflow");
            }
            return new Decimal64(scaleOffset, this.value * FACTOR[diffOffset]);
        }
        int diffOffset = -diff - 1;
        long factor = FACTOR[diffOffset];
        long trunc = this.value / factor;
        long remainder = this.value - trunc * factor;
        if (remainder == 0L) {
            return new Decimal64(scaleOffset, trunc);
        }
        long increment = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case RoundingMode.UP -> Long.signum(trunc);
            case RoundingMode.DOWN -> 0L;
            case RoundingMode.CEILING -> {
                if (Long.signum(trunc) > 0) {
                    yield 1L;
                }
                yield 0L;
            }
            case RoundingMode.FLOOR -> {
                if (Long.signum(trunc) < 0) {
                    yield -1L;
                }
                yield 0L;
            }
            case RoundingMode.HALF_UP -> {
                switch (RemainderSignificance.of(remainder, factor)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LT_HALF: {
                        yield 0L;
                    }
                    case HALF: 
                    case GT_HALF: 
                }
                yield Long.signum(trunc);
            }
            case RoundingMode.HALF_DOWN -> {
                switch (RemainderSignificance.of(remainder, factor)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LT_HALF: 
                    case HALF: {
                        yield 0L;
                    }
                    case GT_HALF: 
                }
                yield Long.signum(trunc);
            }
            case RoundingMode.HALF_EVEN -> {
                switch (RemainderSignificance.of(remainder, factor)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LT_HALF: {
                        yield 0L;
                    }
                    case HALF: {
                        if ((trunc & 1L) != 0L) {
                            yield Long.signum(trunc);
                        }
                        yield 0L;
                    }
                    case GT_HALF: 
                }
                yield Long.signum(trunc);
            }
            case RoundingMode.UNNECESSARY -> throw new ArithmeticException("Decreasing scale of " + this + " to " + scale + " requires rounding");
        };
        return new Decimal64(scaleOffset, trunc + increment);
    }

    public final BigDecimal decimalValue() {
        return BigDecimal.valueOf(this.value, this.scale());
    }

    @Override
    public final int intValue() {
        return (int)this.intPart();
    }

    @Override
    public final long longValue() {
        return this.intPart();
    }

    @Override
    public final float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public final double doubleValue() {
        return 1.0 * (double)this.value / (double)FACTOR[this.offset];
    }

    public final byte byteValueExact() {
        byte ret;
        long val = this.longValueExact();
        if (val != (long)(ret = (byte)val)) {
            throw new ArithmeticException("Value " + val + " is outside of byte range");
        }
        return ret;
    }

    public final short shortValueExact() {
        short ret;
        long val = this.longValueExact();
        if (val != (long)(ret = (short)val)) {
            throw new ArithmeticException("Value " + val + " is outside of short range");
        }
        return ret;
    }

    public final int intValueExact() {
        int ret;
        long val = this.longValueExact();
        if (val != (long)(ret = (int)val)) {
            throw new ArithmeticException("Value " + val + " is outside of integer range");
        }
        return ret;
    }

    public final long longValueExact() {
        if (this.fracPart() != 0L) {
            throw new ArithmeticException("Conversion of " + this + " would lose fraction");
        }
        return this.intPart();
    }

    @Override
    public final int compareTo(Decimal64 o) {
        if (this == o) {
            return 0;
        }
        if (this.offset == o.offset) {
            return Long.compare(this.value, o.value);
        }
        return Double.compare(this.doubleValue(), o.doubleValue());
    }

    @Override
    public final String toCanonicalString() {
        StringBuilder builder = new StringBuilder(21).append(this.value);
        int start = this.value < 0L ? 1 : 0;
        int scale = this.scale();
        int padding = scale + 1 + start - builder.length();
        if (padding > 0) {
            builder.insert(start, "0".repeat(padding));
        }
        int length = builder.length();
        int firstDecimal = length - scale;
        int significantLength = length;
        int i = length - 1;
        while (i > firstDecimal && builder.charAt(i) == '0') {
            significantLength = i--;
        }
        if (significantLength != length) {
            builder.setLength(significantLength);
        }
        return builder.insert(firstDecimal, '.').toString();
    }

    @Override
    public final CanonicalValueSupport<Decimal64> support() {
        return SUPPORT;
    }

    public final int hashCode() {
        return Long.hashCode(this.intPart()) * 31 + Long.hashCode(this.fracPart());
    }

    public final boolean equals(@Nullable Object obj) {
        Decimal64 other;
        return this == obj || obj instanceof Decimal64 && this.equalsImpl(other = (Decimal64)obj);
    }

    public final boolean equals(@Nullable Decimal64 obj) {
        return this == obj || obj != null && this.equalsImpl(obj);
    }

    public final String toString() {
        return this.toCanonicalString();
    }

    private boolean equalsImpl(Decimal64 other) {
        return this.offset == other.offset ? this.value == other.value : this.intPart() == other.intPart() && this.fracPart() == other.fracPart();
    }

    private long intPart() {
        return this.value / FACTOR[this.offset];
    }

    private long fracPart() {
        return this.value % FACTOR[this.offset];
    }

    private static byte offsetOf(int scale) {
        Preconditions.checkArgument((scale >= 1 && scale <= 18 ? 1 : 0) != 0, (String)"Scale %s is not in range [1..%s]", (int)scale, (int)18);
        return (byte)(scale - 1);
    }

    static {
        Verify.verify((CONVERSION.length == 18 ? 1 : 0) != 0);
        Verify.verify((FACTOR.length == 18 ? 1 : 0) != 0);
        MIN_VALUE = new Decimal64[18];
        MAX_VALUE = new Decimal64[18];
        for (byte i = 0; i < 18; i = (byte)(i + 1)) {
            Decimal64.MIN_VALUE[i] = new Decimal64(i, Long.MIN_VALUE);
            Decimal64.MAX_VALUE[i] = new Decimal64(i, Long.MAX_VALUE);
        }
    }

    private static enum RemainderSignificance {
        LT_HALF,
        HALF,
        GT_HALF;


        static RemainderSignificance of(long remainder, long interval) {
            long half;
            long absRemainder = Math.abs(remainder);
            if (absRemainder > (half = interval / 2L)) {
                return GT_HALF;
            }
            if (absRemainder < half) {
                return LT_HALF;
            }
            return HALF;
        }
    }

    public static final class Support
    extends AbstractCanonicalValueSupport<Decimal64> {
        public Support() {
            super(Decimal64.class);
        }

        @Override
        public Either<Decimal64, CanonicalValueViolation> fromString(String str) {
            char ch;
            char ch2;
            int idx;
            boolean negative;
            if (str.isEmpty()) {
                return CanonicalValueViolation.variantOf("Empty string is not a valid decimal64 representation");
            }
            switch (str.charAt(0)) {
                case '-': {
                    negative = true;
                    int n = 1;
                    break;
                }
                case '+': {
                    negative = false;
                    int n = 1;
                    break;
                }
                default: {
                    negative = false;
                    int n = idx = 0;
                }
            }
            if (idx == str.length()) {
                return CanonicalValueViolation.variantOf("Missing digits after sign");
            }
            int limit = str.length() - 1;
            while (idx < limit && str.charAt(idx) == '0' && (ch2 = str.charAt(idx + 1)) >= '0' && ch2 <= '9') {
                ++idx;
            }
            int intLen = 0;
            long intPart = 0L;
            while (idx <= limit && (ch = str.charAt(idx)) != '.') {
                if (intLen == 18) {
                    return CanonicalValueViolation.variantOf("Integer part is longer than 18 digits");
                }
                intPart = 10L * intPart + (long)Support.toInt(ch, idx);
                ++idx;
                ++intLen;
            }
            if (idx > limit) {
                return Either.ofFirst((Object)new Decimal64(1, intPart, 0L, negative));
            }
            if (++idx > limit) {
                return CanonicalValueViolation.variantOf("Value '" + str + "' is missing fraction digits");
            }
            while (idx < limit && str.charAt(limit) == '0') {
                --limit;
            }
            int fracLimit = 18 - intLen + 1;
            int fracLen = 0;
            long fracPart = 0L;
            while (idx <= limit) {
                char ch3 = str.charAt(idx);
                if (fracLen == fracLimit) {
                    return CanonicalValueViolation.variantOf("Fraction part longer than " + fracLimit + " digits");
                }
                fracPart = 10L * fracPart + (long)Support.toInt(ch3, idx);
                ++idx;
                fracLen = (byte)(fracLen + 1);
            }
            return Either.ofFirst((Object)new Decimal64(fracLen, intPart, fracPart, negative));
        }

        private static int toInt(char ch, int index) {
            if (ch < '0' || ch > '9') {
                throw new NumberFormatException("Illegal character at offset " + index);
            }
            return ch - 48;
        }
    }
}

