/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;

@NonNullByDefault
public interface PathExpression
extends Immutable {
    public String getOriginalString();

    public Steps getSteps();

    default public boolean isAbsolute() {
        LocationPathSteps locationSteps;
        Steps steps = this.getSteps();
        return steps instanceof LocationPathSteps && (locationSteps = (LocationPathSteps)steps).getLocationPath().isAbsolute();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Steps {
        Steps() {
        }

        public abstract int hashCode();

        public abstract boolean equals(@Nullable Object var1);

        public final String toString() {
            return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
        }

        abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);
    }

    public static final class LocationPathSteps
    extends Steps {
        private final YangLocationPath locationPath;

        public LocationPathSteps(YangLocationPath locationPath) {
            this.locationPath = Objects.requireNonNull(locationPath);
        }

        public YangLocationPath getLocationPath() {
            return this.locationPath;
        }

        @Override
        public int hashCode() {
            return this.locationPath.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof LocationPathSteps)) return false;
            LocationPathSteps other = (LocationPathSteps)obj;
            if (!this.locationPath.equals((Object)other.locationPath)) return false;
            return true;
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("locationPath", (Object)this.locationPath);
        }
    }

    public static final class DerefSteps
    extends Steps {
        private final YangLocationPath.Relative derefArgument;
        private final YangLocationPath.Relative relativePath;

        public DerefSteps(YangLocationPath.Relative derefArgument, YangLocationPath.Relative relativePath) {
            this.derefArgument = Objects.requireNonNull(derefArgument);
            this.relativePath = Objects.requireNonNull(relativePath);
        }

        public YangLocationPath.Relative getDerefArgument() {
            return this.derefArgument;
        }

        public YangLocationPath.Relative getRelativePath() {
            return this.relativePath;
        }

        @Override
        public int hashCode() {
            return 31 * this.derefArgument.hashCode() + this.relativePath.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof DerefSteps)) return false;
            DerefSteps other = (DerefSteps)obj;
            if (!this.derefArgument.equals((Object)other.derefArgument)) return false;
            if (!this.relativePath.equals((Object)other.relativePath)) return false;
            return true;
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("derefArgument", (Object)this.derefArgument).add("relativePath", (Object)this.relativePath);
        }
    }
}

