/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.spi;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.RefcountedRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;

public class SchemaSourceTransformer<S extends SchemaSourceRepresentation, D extends SchemaSourceRepresentation>
implements SchemaSourceListener,
SchemaSourceProvider<D> {
    private final Map<PotentialSchemaSource<?>, RefcountedRegistration> availableSources = new HashMap();
    private final SchemaSourceRegistry consumer;
    private final SchemaRepository provider;
    private final AsyncFunction<S, D> function;
    private final Class<S> srcClass;
    private final Class<D> dstClass;

    public SchemaSourceTransformer(SchemaRepository provider, Class<S> srcClass, SchemaSourceRegistry consumer, Class<D> dstClass, AsyncFunction<S, D> function) {
        this.provider = Objects.requireNonNull(provider);
        this.consumer = Objects.requireNonNull(consumer);
        this.function = Objects.requireNonNull(function);
        this.srcClass = Objects.requireNonNull(srcClass);
        this.dstClass = Objects.requireNonNull(dstClass);
    }

    @Override
    public final ListenableFuture<D> getSource(SourceIdentifier sourceIdentifier) {
        return Futures.transformAsync((ListenableFuture)this.provider.getSchemaSource(sourceIdentifier, this.srcClass), this.function, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public final void schemaSourceEncountered(SchemaSourceRepresentation source) {
    }

    @Override
    public final void schemaSourceRegistered(Iterable<PotentialSchemaSource<?>> sources) {
        for (PotentialSchemaSource<?> src : sources) {
            Class<?> rep = src.getRepresentation();
            if (!this.srcClass.isAssignableFrom(rep) || this.dstClass == rep) continue;
            this.registerSource(src);
        }
    }

    @Override
    public final void schemaSourceUnregistered(PotentialSchemaSource<?> source) {
        Class<?> rep = source.getRepresentation();
        if (this.srcClass.isAssignableFrom(rep) && this.dstClass != rep) {
            this.unregisterSource(source);
        }
    }

    private void registerSource(PotentialSchemaSource<?> src) {
        RefcountedRegistration reg = this.availableSources.get(src);
        if (reg != null) {
            reg.incRef();
            return;
        }
        PotentialSchemaSource<D> newSrc = PotentialSchemaSource.create(src.getSourceIdentifier(), this.dstClass, src.getCost() + PotentialSchemaSource.Costs.COMPUTATION.getValue());
        SchemaSourceRegistration<D> r = this.consumer.registerSchemaSource(this, newSrc);
        this.availableSources.put(src, new RefcountedRegistration(r));
    }

    private void unregisterSource(PotentialSchemaSource<?> src) {
        RefcountedRegistration reg = this.availableSources.get(src);
        if (reg != null && reg.decRef()) {
            this.availableSources.remove(src);
        }
    }

    @FunctionalInterface
    public static interface Transformation<S extends SchemaSourceRepresentation, D extends SchemaSourceRepresentation>
    extends AsyncFunction<S, D> {
        public ListenableFuture<D> apply(S var1) throws Exception;
    }
}

