/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.FluentFuture;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.spi.AbstractSchemaSourceCache;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;

@Deprecated(since="7.0.13", forRemoval=true)
@Beta
public final class GuavaSchemaSourceCache<T extends SchemaSourceRepresentation>
extends AbstractSchemaSourceCache<T>
implements AutoCloseable {
    private final List<FinalizablePhantomReference<T>> regs = Collections.synchronizedList(new ArrayList());
    private final FinalizableReferenceQueue queue = new FinalizableReferenceQueue();
    private final Cache<SourceIdentifier, T> cache;

    private GuavaSchemaSourceCache(SchemaSourceRegistry consumer, Class<T> representation, CacheBuilder<Object, Object> cacheBuilder) {
        super(consumer, representation, PotentialSchemaSource.Costs.IMMEDIATE);
        this.cache = cacheBuilder.build();
    }

    public static <R extends SchemaSourceRepresentation> @NonNull GuavaSchemaSourceCache<R> createSoftCache(SchemaSourceRegistry consumer, Class<R> representation) {
        return new GuavaSchemaSourceCache<R>(consumer, representation, (CacheBuilder<Object, Object>)CacheBuilder.newBuilder().softValues());
    }

    public static <R extends SchemaSourceRepresentation> @NonNull GuavaSchemaSourceCache<R> createSoftCache(SchemaSourceRegistry consumer, Class<R> representation, long lifetime, TimeUnit units) {
        return new GuavaSchemaSourceCache<R>(consumer, representation, (CacheBuilder<Object, Object>)CacheBuilder.newBuilder().softValues().expireAfterAccess(lifetime, units));
    }

    public static <R extends SchemaSourceRepresentation> @NonNull GuavaSchemaSourceCache<R> createSoftCache(SchemaSourceRegistry consumer, Class<R> representation, Duration duration) {
        return new GuavaSchemaSourceCache<R>(consumer, representation, (CacheBuilder<Object, Object>)CacheBuilder.newBuilder().softValues().expireAfterAccess(duration));
    }

    @Override
    public FluentFuture<? extends T> getSource(SourceIdentifier sourceIdentifier) {
        SchemaSourceRepresentation present = (SchemaSourceRepresentation)this.cache.getIfPresent((Object)sourceIdentifier);
        return present != null ? FluentFutures.immediateFluentFuture((Object)present) : FluentFutures.immediateFailedFluentFuture((Throwable)new MissingSchemaSourceException("Source not found", sourceIdentifier));
    }

    @Override
    protected void offer(T source) {
        SourceIdentifier srcId = source.getIdentifier();
        if (this.cache.getIfPresent((Object)srcId) != null) {
            return;
        }
        this.cache.put((Object)srcId, source);
        final SchemaSourceRegistration reg = this.register(srcId);
        FinalizablePhantomReference ref = new FinalizablePhantomReference<T>((SchemaSourceRepresentation)source, this.queue){

            public void finalizeReferent() {
                reg.close();
                GuavaSchemaSourceCache.this.regs.remove((Object)this);
            }
        };
        this.regs.add(ref);
    }

    @Override
    public void close() {
        while (!this.regs.isEmpty()) {
            FinalizablePhantomReference<T> ref = this.regs.get(0);
            ref.finalizeReferent();
        }
        this.cache.invalidateAll();
        this.queue.close();
    }
}

