/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.spi;

import com.google.common.annotations.Beta;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.spi.AbstractSchemaListenerRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.AbstractSchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaListenerRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractSchemaRepository
implements SchemaRepository,
SchemaSourceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSchemaRepository.class);
    private final @GuardedBy(value={"this"}) Map<SourceIdentifier, ListMultimap<Class<? extends SchemaSourceRepresentation>, AbstractSchemaSourceRegistration<?>>> sources = new HashMap();
    private final @GuardedBy(value={"this"}) List<SchemaListenerRegistration> listeners = new ArrayList<SchemaListenerRegistration>();

    private static <T extends SchemaSourceRepresentation> ListenableFuture<T> fetchSource(SourceIdentifier id, Iterator<AbstractSchemaSourceRegistration<?>> it) {
        AbstractSchemaSourceRegistration<?> reg = it.next();
        return Futures.catchingAsync(reg.getProvider().getSource(id), Throwable.class, input -> {
            LOG.debug("Failed to acquire source from {}", (Object)reg, input);
            if (it.hasNext()) {
                return AbstractSchemaRepository.fetchSource(id, it);
            }
            throw new MissingSchemaSourceException("All available providers exhausted", id, input);
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SchemaSourceRepresentation> ListenableFuture<T> getSchemaSource(final SourceIdentifier id, Class<T> representation) {
        ArrayList sortedSchemaSourceRegistrations;
        AbstractSchemaRepository abstractSchemaRepository = this;
        synchronized (abstractSchemaRepository) {
            ListMultimap<Class<? extends SchemaSourceRepresentation>, AbstractSchemaSourceRegistration<?>> srcs = this.sources.get(id);
            if (srcs == null) {
                return FluentFutures.immediateFailedFluentFuture((Throwable)new MissingSchemaSourceException("No providers registered for source " + id, id));
            }
            sortedSchemaSourceRegistrations = Lists.newArrayList((Iterable)srcs.get(representation));
        }
        sortedSchemaSourceRegistrations.sort(SchemaProviderCostComparator.INSTANCE);
        Iterator<AbstractSchemaSourceRegistration<?>> regs = sortedSchemaSourceRegistrations.iterator();
        if (!regs.hasNext()) {
            return FluentFutures.immediateFailedFluentFuture((Throwable)new MissingSchemaSourceException("No providers for source " + id + " representation " + representation + " available", id));
        }
        ListenableFuture<T> fetchSourceFuture = AbstractSchemaRepository.fetchSource(id, regs);
        Futures.addCallback(fetchSourceFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                for (SchemaListenerRegistration listener : AbstractSchemaRepository.this.listeners) {
                    ((SchemaSourceListener)listener.getInstance()).schemaSourceEncountered((SchemaSourceRepresentation)result);
                }
            }

            public void onFailure(Throwable t) {
                LOG.trace("Skipping notification for encountered source {}, fetching source failed", (Object)id, (Object)t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return fetchSourceFuture;
    }

    private synchronized <T extends SchemaSourceRepresentation> void addSource(PotentialSchemaSource<T> source, AbstractSchemaSourceRegistration<T> reg) {
        ArrayListMultimap map = this.sources.get(source.getSourceIdentifier());
        if (map == null) {
            map = ArrayListMultimap.create();
            this.sources.put(source.getSourceIdentifier(), (ListMultimap<Class<SchemaSourceRepresentation>, AbstractSchemaSourceRegistration<?>>)map);
        }
        map.put(source.getRepresentation(), reg);
        Set<PotentialSchemaSource<?>> reps = Collections.singleton(source);
        for (SchemaListenerRegistration l : this.listeners) {
            ((SchemaSourceListener)l.getInstance()).schemaSourceRegistered(reps);
        }
    }

    private synchronized <T extends SchemaSourceRepresentation> void removeSource(PotentialSchemaSource<?> source, SchemaSourceRegistration<?> reg) {
        Multimap m = (Multimap)this.sources.get(source.getSourceIdentifier());
        if (m != null) {
            m.remove(source.getRepresentation(), reg);
            for (SchemaListenerRegistration l : this.listeners) {
                ((SchemaSourceListener)l.getInstance()).schemaSourceUnregistered(source);
            }
            if (m.isEmpty()) {
                this.sources.remove(source.getSourceIdentifier());
            }
        }
    }

    @Override
    public <T extends SchemaSourceRepresentation> SchemaSourceRegistration<T> registerSchemaSource(SchemaSourceProvider<? super T> provider, PotentialSchemaSource<T> source) {
        final PotentialSchemaSource<T> src = source.cachedReference();
        AbstractSchemaSourceRegistration ret = new AbstractSchemaSourceRegistration<T>(provider, src){

            protected void removeRegistration() {
                AbstractSchemaRepository.this.removeSource(src, this);
            }
        };
        this.addSource(src, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaListenerRegistration registerSchemaSourceListener(SchemaSourceListener listener) {
        AbstractSchemaListenerRegistration ret = new AbstractSchemaListenerRegistration(listener){

            protected void removeRegistration() {
                AbstractSchemaRepository.this.listeners.remove(this);
            }
        };
        AbstractSchemaRepository abstractSchemaRepository = this;
        synchronized (abstractSchemaRepository) {
            ArrayList col = new ArrayList();
            for (Multimap multimap : this.sources.values()) {
                for (AbstractSchemaSourceRegistration r : multimap.values()) {
                    col.add((PotentialSchemaSource)r.getInstance());
                }
            }
            listener.schemaSourceRegistered(col);
            this.listeners.add(ret);
        }
        return ret;
    }

    private static class SchemaProviderCostComparator
    implements Comparator<AbstractSchemaSourceRegistration<?>>,
    Serializable {
        static final SchemaProviderCostComparator INSTANCE = new SchemaProviderCostComparator();
        private static final long serialVersionUID = 1L;

        private SchemaProviderCostComparator() {
        }

        @Override
        public int compare(AbstractSchemaSourceRegistration<?> o1, AbstractSchemaSourceRegistration<?> o2) {
            return ((PotentialSchemaSource)o1.getInstance()).getCost() - ((PotentialSchemaSource)o2.getInstance()).getCost();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

