/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UniqueEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UniqueStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class UniqueStatementSupport
extends AbstractStatementSupport<Set<SchemaNodeIdentifier.Descendant>, UniqueStatement, UniqueEffectiveStatement> {
    private static final Pattern CRLF_PATTERN = Pattern.compile("\r\n", 16);
    private static final Splitter SEP_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)" \t\n").precomputed()).omitEmptyStrings();
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.UNIQUE).build();

    public UniqueStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.UNIQUE, StatementSupport.StatementPolicy.copyDeclared((copy, current, substatements) -> ((Set)copy.getArgument()).equals(current.getArgument())), config, SUBSTATEMENT_VALIDATOR);
    }

    public Set<SchemaNodeIdentifier.Descendant> adaptArgumentValue(StmtContext<Set<SchemaNodeIdentifier.Descendant>, UniqueStatement, UniqueEffectiveStatement> ctx, QNameModule targetModule) {
        Set origArg = (Set)ctx.getArgument();
        if (UniqueStatementSupport.allMatch(origArg.stream().flatMap(desc -> desc.getNodeIdentifiers().stream()), targetModule)) {
            return origArg;
        }
        return (Set)origArg.stream().map(descendant -> {
            List nodeIds = descendant.getNodeIdentifiers();
            return UniqueStatementSupport.allMatch(nodeIds.stream(), targetModule) ? descendant : SchemaNodeIdentifier.Descendant.of((Collection)Lists.transform((List)nodeIds, nodeId -> nodeId.bindTo(targetModule).intern()));
        }).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSet<SchemaNodeIdentifier.Descendant> parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        ImmutableSet<SchemaNodeIdentifier.Descendant> uniqueConstraints = UniqueStatementSupport.parseUniqueConstraintArgument(ctx, value);
        SourceException.throwIf((boolean)uniqueConstraints.isEmpty(), ctx, (String)"Invalid argument value '%s' of unique statement. The value must contains at least one descendant schema node identifier.", (Object[])new Object[]{value});
        return uniqueConstraints;
    }

    public void onStatementAdded(StmtContext.Mutable<Set<SchemaNodeIdentifier.Descendant>, UniqueStatement, UniqueEffectiveStatement> stmt) {
        StmtContext.Mutable list = stmt.coerceParentContext();
        if (list.producesEffective(ListEffectiveStatement.class)) {
            StmtContext.Mutable listParent = list.coerceParentContext();
            ModelActionBuilder action = listParent.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
            action.requiresCtx((StmtContext)list, ModelProcessingPhase.EFFECTIVE_MODEL);
            action.apply((ModelActionBuilder.InferenceAction)new RequireEffectiveList((StmtContext<Set<SchemaNodeIdentifier.Descendant>, ?, ?>)stmt, (StmtContext<?, ?, ?>)list, (StmtContext.Mutable<?, ?, ?>)listParent));
        }
    }

    protected UniqueStatement createDeclared(BoundStmtCtx<Set<SchemaNodeIdentifier.Descendant>> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createUnique((String)ctx.getRawArgument(), (Set)((Set)ctx.getArgument()), substatements);
    }

    protected UniqueStatement attachDeclarationReference(UniqueStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateUnique((UniqueStatement)stmt, (DeclarationReference)reference);
    }

    protected UniqueEffectiveStatement createEffective(EffectiveStmtCtx.Current<Set<SchemaNodeIdentifier.Descendant>, UniqueStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createUnique((UniqueStatement)((UniqueStatement)stmt.declared()), substatements);
    }

    private static boolean allMatch(Stream<QName> qnames, QNameModule module) {
        return qnames.allMatch(qname -> module.equals((Object)qname.getModule()));
    }

    private static ImmutableSet<SchemaNodeIdentifier.Descendant> parseUniqueConstraintArgument(StmtContext<?, ?, ?> ctx, String argumentValue) {
        return (ImmutableSet)SEP_SPLITTER.splitToStream((CharSequence)CRLF_PATTERN.matcher(argumentValue).replaceAll("\n")).map(uniqueArgToken -> {
            SchemaNodeIdentifier patt8017$temp = ArgumentUtils.nodeIdentifierFromPath(ctx, uniqueArgToken);
            if (!(patt8017$temp instanceof SchemaNodeIdentifier.Descendant)) {
                throw new SourceException((CommonStmtCtx)ctx, "Unique statement argument '%s' contains schema node identifier '%s' which is not in the descendant node identifier form.", new Object[]{argumentValue, uniqueArgToken});
            }
            SchemaNodeIdentifier.Descendant descendant = (SchemaNodeIdentifier.Descendant)patt8017$temp;
            return descendant;
        }).collect(ImmutableSet.toImmutableSet());
    }

    private static final class RequireEffectiveList
    implements ModelActionBuilder.InferenceAction {
        private final StmtContext<Set<SchemaNodeIdentifier.Descendant>, ?, ?> unique;
        private final StmtContext<?, ?, ?> list;
        private final StmtContext.Mutable<?, ?, ?> parent;

        RequireEffectiveList(StmtContext<Set<SchemaNodeIdentifier.Descendant>, ?, ?> unique, StmtContext<?, ?, ?> list, StmtContext.Mutable<?, ?, ?> parent) {
            this.unique = Objects.requireNonNull(unique);
            this.list = Objects.requireNonNull(list);
            this.parent = Objects.requireNonNull(parent);
        }

        public void apply(ModelActionBuilder.InferenceContext ctx) {
            if (this.isApplicable()) {
                ModelActionBuilder action = this.parent.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
                action.apply((ModelActionBuilder.InferenceAction)new RequireLeafDescendants(this.unique, (Map<ModelActionBuilder.Prerequisite<StmtContext<?, ?, ?>>, SchemaNodeIdentifier.Descendant>)Maps.uniqueIndex((Iterable)((Iterable)this.unique.getArgument()), desc -> action.requiresEffectiveCtxPath(this.list, ParserNamespaces.schemaTree(), (Iterable)desc.getNodeIdentifiers()))));
            }
        }

        public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
            InferenceException.throwIf((boolean)this.isApplicable(), this.unique, (String)"Parent list failed to reach effective model", (Object[])new Object[0]);
        }

        private boolean isApplicable() {
            return this.list.isSupportedToBuildEffective() && this.list.isSupportedByFeatures() && this.unique.isSupportedToBuildEffective();
        }
    }

    private static final class RequireLeafDescendants
    implements ModelActionBuilder.InferenceAction {
        private final Map<ModelActionBuilder.Prerequisite<StmtContext<?, ?, ?>>, SchemaNodeIdentifier.Descendant> prereqs;
        private final StmtContext<Set<SchemaNodeIdentifier.Descendant>, ?, ?> unique;

        RequireLeafDescendants(StmtContext<Set<SchemaNodeIdentifier.Descendant>, ?, ?> unique, Map<ModelActionBuilder.Prerequisite<StmtContext<?, ?, ?>>, SchemaNodeIdentifier.Descendant> prereqs) {
            this.unique = Objects.requireNonNull(unique);
            this.prereqs = Objects.requireNonNull(prereqs);
        }

        public void apply(ModelActionBuilder.InferenceContext ctx) {
            for (Map.Entry<ModelActionBuilder.Prerequisite<StmtContext<?, ?, ?>>, SchemaNodeIdentifier.Descendant> entry : this.prereqs.entrySet()) {
                StmtContext stmt = (StmtContext)entry.getKey().resolve(ctx);
                SourceException.throwIf((!stmt.producesEffective(LeafEffectiveStatement.class) ? 1 : 0) != 0, this.unique, (String)"Path %s resolved to non-leaf %s", (Object[])new Object[]{stmt.publicDefinition().getStatementName()});
            }
        }

        public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
            ImmutableBiMap inv = ImmutableBiMap.copyOf(this.prereqs);
            Object[] objectArray = new Object[1];
            objectArray[0] = failed.stream().map(arg_0 -> ((ImmutableBiMap)inv).get(arg_0)).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            throw new SourceException(this.unique, "Following components of unique statement argument refer to non-existent nodes: %s", objectArray);
        }
    }
}

