/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

@Beta
public final class EnumStatementSupport
extends AbstractStatementSupport<String, EnumStatement, EnumEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ENUM).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.VALUE).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ENUM).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.VALUE).build();

    private EnumStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.ENUM, StatementSupport.StatementPolicy.contextIndependent(), config, validator);
    }

    public static @NonNull EnumStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new EnumStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull EnumStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new EnumStatementSupport(config, RFC7950_VALIDATOR);
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    protected EnumStatement createDeclared(BoundStmtCtx<String> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createEnum((String)ctx.getRawArgument(), (String)((String)ctx.getArgument()), substatements);
    }

    protected EnumStatement attachDeclarationReference(EnumStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateEnum((EnumStatement)stmt, (DeclarationReference)reference);
    }

    protected EnumEffectiveStatement createEffective(EffectiveStmtCtx.Current<String, EnumStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createEnum((EnumStatement)((EnumStatement)stmt.declared()), substatements);
    }
}

