/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class AnyxmlStatementSupport
extends AbstractSchemaTreeStatementSupport<AnyxmlStatement, AnyxmlEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ANYXML).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();

    public AnyxmlStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.ANYXML, AnyxmlStatementSupport.instantiatedPolicy(), config, SUBSTATEMENT_VALIDATOR);
    }

    protected AnyxmlStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createAnyxml((QName)((QName)ctx.getArgument()), substatements);
    }

    protected AnyxmlStatement attachDeclarationReference(AnyxmlStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateAnyxml((AnyxmlStatement)stmt, (DeclarationReference)reference);
    }

    protected AnyxmlEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, AnyxmlStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createAnyxml((AnyxmlStatement)((AnyxmlStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)AnyxmlStatementSupport.createFlags(stmt, substatements), substatements);
    }

    public AnyxmlEffectiveStatement copyEffective(EffectiveStmtCtx.Current<QName, AnyxmlStatement> stmt, AnyxmlEffectiveStatement original) {
        return EffectiveStatements.copyAnyxml((AnyxmlEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)AnyxmlStatementSupport.createFlags(stmt, original.effectiveSubstatements()));
    }

    public EffectiveStatementState extractEffectiveState(AnyxmlEffectiveStatement stmt) {
        Verify.verify((boolean)(stmt instanceof AnyxmlSchemaNode), (String)"Unexpected statement %s", (Object)stmt);
        AnyxmlSchemaNode schema = (AnyxmlSchemaNode)stmt;
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)schema).setStatus(schema.getStatus()).setConfiguration((Boolean)schema.effectiveConfig().orElse(null)).setMandatory(schema.isMandatory()).toFlags());
    }

    private static int createFlags(EffectiveStmtCtx.Current<QName, AnyxmlStatement> stmt, Collection<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)stmt.history()).setStatus((Status)AnyxmlStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).setConfiguration(stmt.effectiveConfig().asNullable()).setMandatory(((Boolean)AnyxmlStatementSupport.findFirstArgument(substatements, MandatoryEffectiveStatement.class, (Object)Boolean.FALSE)).booleanValue()).toFlags();
    }
}

