/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationStatement;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification.AbstractNotificationStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class NotificationStatementRFC7950Support
extends AbstractNotificationStatementSupport {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.NOTIFICATION).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CHOICE).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.USES).build();
    private static final ImmutableSet<StatementDefinition> ILLEGAL_PARENTS = ImmutableSet.of((Object)YangStmtMapping.NOTIFICATION, (Object)YangStmtMapping.RPC, (Object)YangStmtMapping.ACTION);

    public NotificationStatementRFC7950Support(YangParserConfiguration config) {
        super(config, SUBSTATEMENT_VALIDATOR);
    }

    public void onStatementAdded(StmtContext.Mutable<QName, NotificationStatement, NotificationEffectiveStatement> stmt) {
        QName argument = (QName)stmt.argument();
        SourceException.throwIf((boolean)StmtContextUtils.hasAncestorOfType(stmt, ILLEGAL_PARENTS), stmt, (String)"Notification %s is defined within an rpc, action, or another notification", (Object[])new Object[]{argument});
        SourceException.throwIf((boolean)StmtContextUtils.hasParentOfType(stmt, (StatementDefinition)YangStmtMapping.CASE), stmt, (String)"Notification %s is defined within a case statement", (Object[])new Object[]{argument});
        StmtContextUtils.validateNoKeylessListAncestorOf(stmt, (String)"Notification");
        super.onStatementAdded(stmt);
    }
}

